/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.feedcomm.ws;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import javax.websocket.RemoteEndpoint;
import javax.websocket.Session;
import org.hawkular.bus.common.BasicMessage;
import org.hawkular.feedcomm.api.ApiDeserializer;
import org.hawkular.feedcomm.ws.MsgLogger;
import org.hawkular.feedcomm.ws.WebSocketHelper;

public class WebSocketHelper {
    private Long asyncTimeout;

    public WebSocketHelper() {
        this.asyncTimeout = null;
    }

    public WebSocketHelper(Long asyncTimeout) {
        this.asyncTimeout = asyncTimeout;
    }

    public void sendBasicMessageAsync(Collection<Session> sessions, BasicMessage msg) {
        String text = ApiDeserializer.toHawkularFormat((BasicMessage)msg);
        this.sendTextAsync(sessions, text);
    }

    public void sendBasicMessageSync(Collection<Session> sessions, BasicMessage msg) throws IOException {
        String text = ApiDeserializer.toHawkularFormat((BasicMessage)msg);
        this.sendTextSync(sessions, text);
    }

    public void sendTextAsync(Collection<Session> sessions, String text) {
        if (sessions == null || sessions.isEmpty()) {
            return;
        }
        if (text == null) {
            throw new IllegalArgumentException("text message must not be null");
        }
        MsgLogger.LOG.infof("Attempting to send async message to [%d] clients: [%s]", (Object)sessions.size(), (Object)text);
        for (Session session : sessions) {
            if (!session.isOpen()) continue;
            RemoteEndpoint.Async asyncRemote = session.getAsyncRemote();
            if (this.asyncTimeout != null) {
                asyncRemote.setSendTimeout(this.asyncTimeout.longValue());
            }
            asyncRemote.sendText(text);
        }
    }

    public void sendTextSync(Collection<Session> sessions, String text) throws IOException {
        if (sessions == null || sessions.isEmpty()) {
            return;
        }
        if (text == null) {
            throw new IllegalArgumentException("text message must not be null");
        }
        MsgLogger.LOG.infof("Attempting to send message to [%d] clients: [%s]", (Object)sessions.size(), (Object)text);
        for (Session session : sessions) {
            if (!session.isOpen()) continue;
            RemoteEndpoint.Basic basicRemote = session.getBasicRemote();
            basicRemote.sendText(text);
        }
    }

    public void sendBinaryAsync(Session session, InputStream inputStream, ExecutorService threadPool) {
        if (session == null) {
            return;
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream must not be null");
        }
        MsgLogger.LOG.infof("Attempting to send async binary data to client [%s]", (Object)session.getId());
        if (session.isOpen()) {
            if (this.asyncTimeout != null) {
                // empty if block
            }
            CopyStreamRunnable runnable = new CopyStreamRunnable(this, session, inputStream);
            threadPool.execute((Runnable)runnable);
        }
    }

    public void sendBinarySync(Session session, InputStream inputStream) throws IOException {
        if (session == null) {
            return;
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream must not be null");
        }
        MsgLogger.LOG.infof("Attempting to send binary data to client [%s]", (Object)session.getId());
        if (session.isOpen()) {
            long size = new CopyStreamRunnable(this, session, inputStream).copyInputToOutput();
            MsgLogger.LOG.infof("Finished sending binary data to client [%s]: size=[%s]", (Object)session.getId(), (Object)size);
        }
    }

    public void sendBasicMessageAsync(Session session, BasicMessage msg) {
        this.sendBasicMessageAsync(Collections.singletonList(session), msg);
    }

    public void sendBasicMessageSync(Session session, BasicMessage msg) throws IOException {
        this.sendBasicMessageSync(Collections.singletonList(session), msg);
    }

    public void sendTextAsync(Session session, String text) {
        this.sendTextAsync(Collections.singletonList(session), text);
    }

    public void sendTextSync(Session session, String text) throws IOException {
        this.sendTextSync(Collections.singletonList(session), text);
    }
}

