/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.feedcomm.ws.mdb;

import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import javax.websocket.Session;
import org.hawkular.bus.common.BasicMessage;
import org.hawkular.bus.common.BasicMessageWithExtraData;
import org.hawkular.bus.common.BinaryData;
import org.hawkular.bus.common.consumer.BasicMessageListener;
import org.hawkular.feedcomm.api.ApiDeserializer;
import org.hawkular.feedcomm.api.DeployApplicationRequest;
import org.hawkular.feedcomm.ws.MsgLogger;
import org.hawkular.feedcomm.ws.WebSocketHelper;
import org.hawkular.feedcomm.ws.server.ConnectedFeeds;

public class DeployApplicationListener
extends BasicMessageListener<DeployApplicationRequest> {
    private final ConnectedFeeds connectedFeeds;
    private final ExecutorService threadPool;

    public DeployApplicationListener(ConnectedFeeds connectedFeeds, ExecutorService threadPool) {
        this.connectedFeeds = connectedFeeds;
        this.threadPool = threadPool;
    }

    protected void onBasicMessage(BasicMessageWithExtraData<DeployApplicationRequest> request) {
        try {
            DeployApplicationRequest basicMessage = (DeployApplicationRequest)request.getBasicMessage();
            String feedId = (String)basicMessage.getHeaders().get("feedId");
            if (feedId == null) {
                throw new IllegalArgumentException("Missing header: feedId");
            }
            Session session = this.connectedFeeds.getSession(feedId);
            if (session == null) {
                return;
            }
            MsgLogger.LOG.infof("Sending feed [%s] an application [%s] to deploy on resource [%s]", (Object)feedId, (Object)basicMessage.getDestinationFileName(), (Object)basicMessage.getResourceId());
            BinaryData dataToSend = ApiDeserializer.toHawkularFormat((BasicMessage)basicMessage, (InputStream)request.getBinaryData());
            new WebSocketHelper().sendBinaryAsync(session, (InputStream)dataToSend, this.threadPool);
            return;
        }
        catch (Exception e) {
            MsgLogger.LOG.errorf((Throwable)e, "Cannot process deploy application request", new Object[0]);
            return;
        }
    }
}

