/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.feedcomm.ws.mdb;

import java.util.Collection;
import javax.websocket.Session;
import org.hawkular.bus.common.BasicMessage;
import org.hawkular.bus.common.BasicMessageWithExtraData;
import org.hawkular.bus.common.consumer.BasicMessageListener;
import org.hawkular.feedcomm.api.DeployApplicationResponse;
import org.hawkular.feedcomm.ws.MsgLogger;
import org.hawkular.feedcomm.ws.WebSocketHelper;
import org.hawkular.feedcomm.ws.server.ConnectedUIClients;

public class DeployApplicationResponseListener
extends BasicMessageListener<DeployApplicationResponse> {
    private ConnectedUIClients connectedUIClients;

    public DeployApplicationResponseListener(ConnectedUIClients connectedUIClients) {
        this.connectedUIClients = connectedUIClients;
    }

    protected void onBasicMessage(BasicMessageWithExtraData<DeployApplicationResponse> responseWithData) {
        try {
            DeployApplicationResponse response = (DeployApplicationResponse)responseWithData.getBasicMessage();
            String uiClientId = (String)response.getHeaders().get("uiClientId");
            if (uiClientId == null) {
                MsgLogger.LOG.warnf("HACK: Telling ALL UI that app [%s] deploy on resource ID [%s] resulted in [%s][%s]", new Object[]{response.getDestinationFileName(), response.getResourceId(), response.getStatus(), response.getMessage()});
                new WebSocketHelper().sendBasicMessageAsync((Collection)this.connectedUIClients.getAllSessions(), (BasicMessage)response);
                return;
            }
            Session session = this.connectedUIClients.getSessionBySessionId(uiClientId);
            if (session == null) {
                return;
            }
            MsgLogger.LOG.infof("Telling UI client [%s] that app [%s] deployment on resource ID [%s] resulted in [%s][%s]", new Object[]{uiClientId, response.getDestinationFileName(), response.getResourceId(), response.getStatus(), response.getMessage()});
            new WebSocketHelper().sendBasicMessageAsync(session, (BasicMessage)response);
            return;
        }
        catch (Exception e) {
            MsgLogger.LOG.errorf((Throwable)e, "Cannot process DeployApplicationResponse message", new Object[0]);
            return;
        }
    }
}

