/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.feedcomm.ws.server;

import java.io.IOException;
import java.io.InputStream;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import javax.websocket.CloseReason;
import javax.websocket.OnClose;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.hawkular.bus.common.BasicMessage;
import org.hawkular.bus.common.BasicMessageWithExtraData;
import org.hawkular.bus.common.BinaryData;
import org.hawkular.feedcomm.api.ApiDeserializer;
import org.hawkular.feedcomm.api.GenericErrorResponse;
import org.hawkular.feedcomm.api.GenericErrorResponseBuilder;
import org.hawkular.feedcomm.ws.Constants;
import org.hawkular.feedcomm.ws.MsgLogger;
import org.hawkular.feedcomm.ws.command.Command;
import org.hawkular.feedcomm.ws.command.CommandContext;
import org.hawkular.feedcomm.ws.server.ConnectedFeeds;
import org.hawkular.feedcomm.ws.server.ConnectedUIClients;
import org.hawkular.feedcomm.ws.server.FeedListenerGenerator;

@ServerEndpoint(value="/feed/{feedId}")
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class FeedCommWebSocket {
    @Inject
    private ConnectedFeeds connectedFeeds;
    @Inject
    private ConnectedUIClients connectedUIClients;
    @Inject
    private FeedListenerGenerator feedListenerGenerator;

    @OnOpen
    public void feedSessionOpen(Session session, @PathParam(value="feedId") String feedId) {
        MsgLogger.LOG.infoFeedSessionOpened(feedId, session.getId());
        boolean successfullyAddedSession = this.connectedFeeds.addSession(feedId, session);
        if (successfullyAddedSession) {
            try {
                this.feedListenerGenerator.addListeners(feedId);
            }
            catch (Exception e) {
                MsgLogger.LOG.errorFailedToAddMessageListenersForFeed(feedId, session.getId(), (Throwable)e);
                try {
                    session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.UNEXPECTED_CONDITION, "Internal server error"));
                }
                catch (IOException ioe) {
                    MsgLogger.LOG.errorf((Throwable)ioe, "Failed to close feed [%s] session [%s] after internal server error", (Object)feedId, (Object)session.getId());
                }
            }
        }
    }

    @OnMessage
    public String feedMessage(String nameAndJsonStr, Session session, @PathParam(value="feedId") String feedId) {
        GenericErrorResponse response;
        MsgLogger.LOG.infoReceivedMessageFromFeed(feedId);
        String requestClassName = "?";
        try {
            BasicMessage request = new ApiDeserializer().deserialize(nameAndJsonStr);
            requestClassName = request.getClass().getName();
            Class commandClass = Constants.VALID_COMMANDS_FROM_FEED.get(requestClassName);
            if (commandClass == null) {
                MsgLogger.LOG.errorInvalidCommandRequestFeed(feedId, requestClassName);
                String errorMessage = "Invalid command request: " + requestClassName;
                response = new GenericErrorResponseBuilder().setErrorMessage(errorMessage).build();
            } else {
                CommandContext context = new CommandContext(this.connectedFeeds, this.connectedUIClients, this.feedListenerGenerator.getConnectionFactory(), session);
                Command command = (Command)commandClass.newInstance();
                response = command.execute(request, null, context);
            }
        }
        catch (Throwable t) {
            MsgLogger.LOG.errorCommandExecutionFailureFeed(requestClassName, feedId, t);
            String errorMessage = "Command failed [" + requestClassName + "]";
            response = new GenericErrorResponseBuilder().setThrowable(t).setErrorMessage(errorMessage).build();
        }
        String responseText = response == null ? null : ApiDeserializer.toHawkularFormat((BasicMessage)response);
        return responseText;
    }

    @OnMessage
    public String feedBinaryData(InputStream binaryDataStream, Session session, @PathParam(value="feedId") String feedId) {
        GenericErrorResponse response;
        MsgLogger.LOG.infoReceivedBinaryDataFromFeed(feedId);
        String requestClassName = "?";
        try {
            BasicMessageWithExtraData reqWithData = new ApiDeserializer().deserialize(binaryDataStream);
            BasicMessage request = reqWithData.getBasicMessage();
            BinaryData binaryData = reqWithData.getBinaryData();
            requestClassName = request.getClass().getName();
            Class commandClass = Constants.VALID_COMMANDS_FROM_FEED.get(requestClassName);
            if (commandClass == null) {
                MsgLogger.LOG.errorInvalidCommandRequestFeed(feedId, requestClassName);
                String errorMessage = "Invalid command request: " + requestClassName;
                response = new GenericErrorResponseBuilder().setErrorMessage(errorMessage).build();
            } else {
                CommandContext context = new CommandContext(this.connectedFeeds, this.connectedUIClients, this.feedListenerGenerator.getConnectionFactory(), session);
                Command command = (Command)commandClass.newInstance();
                response = command.execute(request, binaryData, context);
            }
        }
        catch (Throwable t) {
            MsgLogger.LOG.errorCommandExecutionFailureFeed(requestClassName, feedId, t);
            String errorMessage = "Command failed [" + requestClassName + "]";
            response = new GenericErrorResponseBuilder().setThrowable(t).setErrorMessage(errorMessage).build();
        }
        String responseText = response == null ? null : ApiDeserializer.toHawkularFormat((BasicMessage)response);
        return responseText;
    }

    @OnClose
    public void feedSessionClose(Session session, CloseReason reason, @PathParam(value="feedId") String feedId) {
        boolean removed;
        MsgLogger.LOG.infoFeedSessionClosed(feedId, reason);
        boolean bl = removed = this.connectedFeeds.removeSession(feedId, session) != null;
        if (removed) {
            this.feedListenerGenerator.removeListeners(feedId);
        }
    }
}

