/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.feedcomm.ws.server;

import java.io.IOException;
import java.io.InputStream;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import javax.websocket.CloseReason;
import javax.websocket.OnClose;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.hawkular.bus.common.BasicMessage;
import org.hawkular.bus.common.BasicMessageWithExtraData;
import org.hawkular.bus.common.BinaryData;
import org.hawkular.feedcomm.api.ApiDeserializer;
import org.hawkular.feedcomm.api.GenericErrorResponse;
import org.hawkular.feedcomm.api.GenericErrorResponseBuilder;
import org.hawkular.feedcomm.ws.Constants;
import org.hawkular.feedcomm.ws.MsgLogger;
import org.hawkular.feedcomm.ws.command.Command;
import org.hawkular.feedcomm.ws.command.CommandContext;
import org.hawkular.feedcomm.ws.server.ConnectedFeeds;
import org.hawkular.feedcomm.ws.server.ConnectedUIClients;
import org.hawkular.feedcomm.ws.server.UIClientListenerGenerator;

@ServerEndpoint(value="/ui/ws")
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class UIClientCommWebSocket {
    @Inject
    private ConnectedFeeds connectedFeeds;
    @Inject
    private ConnectedUIClients connectedUIClients;
    @Inject
    private UIClientListenerGenerator uiClientListenerGenerator;

    @OnOpen
    public void uiClientSessionOpen(Session session) {
        MsgLogger.LOG.infoUIClientSessionOpened(session.getId());
        this.connectedUIClients.addSession(session);
        String uiClientID = this.getUIClientIDFromSession(session);
        try {
            this.uiClientListenerGenerator.addListeners(uiClientID);
        }
        catch (Exception e) {
            MsgLogger.LOG.errorFailedToAddMessageListenersForUIClient(uiClientID, session.getId(), (Throwable)e);
            try {
                session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.UNEXPECTED_CONDITION, "Internal server error"));
            }
            catch (IOException ioe) {
                MsgLogger.LOG.errorf((Throwable)ioe, "Failed to close UI client [%s] (session [%s]) after internal server error", (Object)uiClientID, (Object)session.getId());
            }
        }
    }

    @OnMessage
    public String uiClientMessage(String nameAndJsonStr, Session session) {
        GenericErrorResponse response;
        String uiClientId = this.getUIClientIDFromSession(session);
        MsgLogger.LOG.infoReceivedMessageFromUIClient(uiClientId, session.getId());
        String requestClassName = "?";
        try {
            BasicMessage request = new ApiDeserializer().deserialize(nameAndJsonStr);
            requestClassName = request.getClass().getName();
            Class commandClass = Constants.VALID_COMMANDS_FROM_UI.get(requestClassName);
            if (commandClass == null) {
                MsgLogger.LOG.errorInvalidCommandRequestUIClient(uiClientId, session.getId(), requestClassName);
                String errorMessage = "Invalid command request: " + requestClassName;
                response = new GenericErrorResponseBuilder().setErrorMessage(errorMessage).build();
            } else {
                CommandContext context = new CommandContext(this.connectedFeeds, this.connectedUIClients, this.uiClientListenerGenerator.getConnectionFactory(), session);
                Command command = (Command)commandClass.newInstance();
                response = command.execute(request, null, context);
            }
        }
        catch (Throwable t) {
            MsgLogger.LOG.errorCommandExecutionFailureUIClient(requestClassName, uiClientId, session.getId(), t);
            String errorMessage = "Command failed [" + requestClassName + "]";
            response = new GenericErrorResponseBuilder().setThrowable(t).setErrorMessage(errorMessage).build();
        }
        String responseText = response == null ? null : ApiDeserializer.toHawkularFormat((BasicMessage)response);
        return responseText;
    }

    @OnMessage
    public String uiClientBinaryData(InputStream binaryDataStream, Session session) {
        GenericErrorResponse response;
        String uiClientId = this.getUIClientIDFromSession(session);
        MsgLogger.LOG.infoReceivedBinaryDataFromUIClient(session.getId());
        String requestClassName = "?";
        try {
            BasicMessageWithExtraData reqWithData = new ApiDeserializer().deserialize(binaryDataStream);
            BasicMessage request = reqWithData.getBasicMessage();
            BinaryData binaryData = reqWithData.getBinaryData();
            requestClassName = request.getClass().getName();
            Class commandClass = Constants.VALID_COMMANDS_FROM_UI.get(requestClassName);
            if (commandClass == null) {
                MsgLogger.LOG.errorInvalidCommandRequestUIClient(uiClientId, session.getId(), requestClassName);
                String errorMessage = "Invalid command request: " + requestClassName;
                response = new GenericErrorResponseBuilder().setErrorMessage(errorMessage).build();
            } else {
                CommandContext context = new CommandContext(this.connectedFeeds, this.connectedUIClients, this.uiClientListenerGenerator.getConnectionFactory(), session);
                Command command = (Command)commandClass.newInstance();
                response = command.execute(request, binaryData, context);
            }
        }
        catch (Throwable t) {
            MsgLogger.LOG.errorCommandExecutionFailureUIClient(requestClassName, uiClientId, session.getId(), t);
            String errorMessage = "Command failed [" + requestClassName + "]";
            response = new GenericErrorResponseBuilder().setThrowable(t).setErrorMessage(errorMessage).build();
        }
        String responseText = response == null ? null : ApiDeserializer.toHawkularFormat((BasicMessage)response);
        return responseText;
    }

    @OnClose
    public void uiClientSessionClose(Session session, CloseReason reason) {
        String uiClientId = this.getUIClientIDFromSession(session);
        MsgLogger.LOG.infoUISessionClosed(uiClientId, session.getId(), reason);
        this.connectedUIClients.removeSession(session);
        this.uiClientListenerGenerator.removeListeners(uiClientId);
    }

    private String getUIClientIDFromSession(Session session) {
        return session.getId();
    }
}

