/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.feedcomm.ws.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.jms.ConnectionFactory;
import javax.naming.InitialContext;
import javax.persistence.PostRemove;
import org.hawkular.bus.common.ConnectionContextFactory;
import org.hawkular.bus.common.Endpoint;
import org.hawkular.bus.common.MessageProcessor;
import org.hawkular.bus.common.consumer.AbstractBasicMessageListener;
import org.hawkular.bus.common.consumer.ConsumerConnectionContext;
import org.hawkular.feedcomm.ws.Constants;
import org.hawkular.feedcomm.ws.MsgLogger;
import org.hawkular.feedcomm.ws.mdb.DeployApplicationResponseListener;
import org.hawkular.feedcomm.ws.mdb.ExecuteOperationResponseListener;
import org.hawkular.feedcomm.ws.server.ConnectedUIClients;

@Startup
@Singleton
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class UIClientListenerGenerator {
    @EJB
    private ConnectedUIClients connectedUIClients;
    @Resource(mappedName="java:/HawkularBusConnectionFactory")
    private ConnectionFactory connectionFactory;
    private Map<String, ConnectionContextFactory> connContextFactories;
    private Map<String, List<ConsumerConnectionContext>> consumerContexts;

    @PostConstruct
    public void initialize() throws Exception {
        if (this.connectionFactory == null) {
            MsgLogger.LOG.warnf("Injection of ConnectionFactory is not working - looking it up explicitly", new Object[0]);
            InitialContext ctx = new InitialContext();
            this.connectionFactory = (ConnectionFactory)ctx.lookup("java:/HawkularBusConnectionFactory");
        } else {
            MsgLogger.LOG.warnf("Injection of ConnectionFactory works - you can remove the hack", new Object[0]);
        }
        this.connContextFactories = new HashMap();
        this.consumerContexts = new HashMap();
    }

    @PostRemove
    public void shutdown() throws Exception {
        if (this.connContextFactories != null) {
            for (String uiClientId : this.connContextFactories.keySet()) {
                this.removeListeners(uiClientId);
            }
        }
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void addListeners(String uiClientId) throws Exception {
        this.removeListeners(uiClientId);
        ConnectionContextFactory ccf = new ConnectionContextFactory(true, this.connectionFactory);
        this.connContextFactories.put(uiClientId, ccf);
        ArrayList<ConsumerConnectionContext> contextList = new ArrayList<ConsumerConnectionContext>();
        this.consumerContexts.put(uiClientId, contextList);
        MsgLogger.LOG.infoAddingListenersForUIClient(uiClientId);
        MessageProcessor messageProcessor = new MessageProcessor();
        String messageSelector = String.format("%s = '%s'", "uiClientId", uiClientId);
        Endpoint endpoint = Constants.DEST_UICLIENT_EXECUTE_OP_RESPONSE;
        ConsumerConnectionContext ccc = ccf.createConsumerConnectionContext(endpoint, null);
        messageProcessor.listen(ccc, (AbstractBasicMessageListener)new ExecuteOperationResponseListener(this.connectedUIClients));
        contextList.add(ccc);
        endpoint = Constants.DEST_UICLIENT_DEPLOY_APPLICATION_RESPONSE;
        ccc = ccf.createConsumerConnectionContext(endpoint, null);
        messageProcessor.listen(ccc, (AbstractBasicMessageListener)new DeployApplicationResponseListener(this.connectedUIClients));
        contextList.add(ccc);
        endpoint = Constants.DEST_UICLIENT_EXECUTE_OP_RESPONSE;
        ccc = ccf.createConsumerConnectionContext(endpoint, messageSelector);
        messageProcessor.listen(ccc, (AbstractBasicMessageListener)new ExecuteOperationResponseListener(this.connectedUIClients));
        contextList.add(ccc);
        endpoint = Constants.DEST_UICLIENT_DEPLOY_APPLICATION_RESPONSE;
        ccc = ccf.createConsumerConnectionContext(endpoint, null);
        messageProcessor.listen(ccc, (AbstractBasicMessageListener)new DeployApplicationResponseListener(this.connectedUIClients));
        contextList.add(ccc);
    }

    public void removeListeners(String uiClientId) {
        List contextList = (List)this.consumerContexts.remove(uiClientId);
        ConnectionContextFactory factory = (ConnectionContextFactory)this.connContextFactories.remove(uiClientId);
        if (contextList != null) {
            for (ConsumerConnectionContext context : contextList) {
                try {
                    context.close();
                }
                catch (Exception e) {
                    MsgLogger.LOG.errorFailedClosingConsumerContext((Throwable)e);
                }
            }
        }
        if (factory != null) {
            try {
                MsgLogger.LOG.infoRemovingListenersForUIClient(uiClientId);
                factory.close();
            }
            catch (Exception e) {
                MsgLogger.LOG.errorFailedRemovingListenersForUIClient(uiClientId, (Throwable)e);
            }
        }
    }
}

