/*
 * Copyright 2015-2016 Red Hat, Inc. and/or its affiliates
 * and other contributors as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.hawkular.client.metrics.jaxrs.handlers;

import java.util.List;
import java.util.Map;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.hawkular.client.metrics.model.Order;
import org.hawkular.metrics.model.DataPoint;
import org.hawkular.metrics.model.Metric;
import org.hawkular.metrics.model.param.Tags;

/**
 * String API
 * http://www.hawkular.org/docs/rest/rest-metrics.html#_string
 */
@Path("/hawkular/metrics/strings")
@Produces(MediaType.APPLICATION_JSON)
@Consumes(MediaType.APPLICATION_JSON)
public interface StringHandler {

    @GET
    @Path("/")
    Response findMetricsDefinitions(@QueryParam("tags") Tags tags);

    @POST
    @Path("/")
    Response createStringMetric(@QueryParam("overwrite") Boolean overwrite, Metric<String> metric);

    @POST
    @Path("/raw")
    Response createStringMetric(List<Metric<String>> metrics);

    @GET
    @Path("/tags/{tags}")
    Response findMetricTags(@PathParam("tags") Tags tags);

    @GET
    @Path("/{id}")
    Response getMetricDefinitions(@PathParam("id") String id);

    @GET
    @Path("/{id}/raw")
    Response getMetricDefinitionsData(
        @PathParam("id") String id,
        @QueryParam("start") String start,
        @QueryParam("end") String end,
        @QueryParam("distinct") Boolean distinct,
        @QueryParam("limit") Integer limit,
        @QueryParam("order") Order order);

    @POST
    @Path("/{id}/raw")
    Response createMetricDefinitionsData(@PathParam("id") String id, List<DataPoint<String>> dataPoints);

    @GET
    @Path("/{id}/tags")
    Response findMetricDefinitionsTags(@PathParam("id") String id);

    @PUT
    @Path("/{id}/tags")
    Response updateMetricDefinitionsTags(@PathParam("id") String id, Map<String, String> tags);

    @DELETE
    @Path("/{id}/tags/{tags}")
    Response deleteMetricDefinitionsTags(@PathParam("id") String id, @PathParam("tags") Tags tags);
}
