/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.client.core;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Map;
import java.util.Optional;

public final class ClientInfo {
    private final URI endpointUri;
    private final Optional<String> username;
    private final Optional<String> password;
    private final Map<String, Object> headers;

    public ClientInfo(URI endpointUri, Optional<String> username, Optional<String> password, Map<String, Object> headers) {
        this.endpointUri = (URI)Preconditions.checkNotNull((Object)endpointUri);
        this.username = (Optional)Preconditions.checkNotNull(username);
        this.password = (Optional)Preconditions.checkNotNull(password);
        this.headers = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(headers)));
    }

    public URI getEndpointUri() {
        return this.endpointUri;
    }

    public Optional<String> getUsername() {
        return this.username;
    }

    public Optional<String> getPassword() {
        return this.password;
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientInfo that = (ClientInfo)o;
        if (this.endpointUri != null ? !this.endpointUri.equals(that.endpointUri) : that.endpointUri != null) {
            return false;
        }
        if (this.username != null ? !this.username.equals(that.username) : that.username != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(that.password) : that.password != null) {
            return false;
        }
        return this.headers != null ? this.headers.equals(that.headers) : that.headers == null;
    }

    public int hashCode() {
        int result = this.endpointUri != null ? this.endpointUri.hashCode() : 0;
        result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        result = 31 * result + (this.headers != null ? this.headers.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ClientInfo{endpointUri=" + this.endpointUri + ", username=" + this.username + ", password=" + this.password + ", headers=" + this.headers + '}';
    }
}

