/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.client.core;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import org.hawkular.client.alert.AlertsClient;
import org.hawkular.client.alert.AlertsClientImpl;
import org.hawkular.client.core.ClientInfo;
import org.hawkular.client.core.HawkularClientBuilder;
import org.hawkular.client.inventory.InventoryClient;
import org.hawkular.client.inventory.InventoryClientImpl;
import org.hawkular.client.metrics.MetricsClient;
import org.hawkular.client.metrics.MetricsClientImpl;

public class HawkularClient {
    static final String KEY_HEADER_TENANT = "Hawkular-Tenant";
    static final String KEY_HEADER_AUTHORIZATION = "Authorization";
    static final String KEY_HEADER_ADMIN_TOKEN = "Hawkular-Admin-Token";
    private MetricsClient metricsClient;
    private InventoryClient inventoryClient;
    private AlertsClient alertsClient;
    private ClientInfo clientInfo;

    public HawkularClient(ClientInfo clientInfo) {
        Preconditions.checkNotNull((Object)clientInfo);
        Preconditions.checkArgument((boolean)clientInfo.getHeaders().containsKey(KEY_HEADER_TENANT), (Object)"Hawkular-Tenant header is missing");
        this.clientInfo = clientInfo;
        this.metricsClient = new MetricsClientImpl(clientInfo);
        this.inventoryClient = new InventoryClientImpl(clientInfo);
        this.alertsClient = new AlertsClientImpl(clientInfo);
    }

    @Deprecated
    public HawkularClient(URI endpointUri, Map<String, Object> headers) {
        this(new ClientInfo(endpointUri, Optional.empty(), Optional.empty(), headers));
    }

    @Deprecated
    public HawkularClient(URI endpointUri, String username, String password, Map<String, Object> headers) {
        this(new ClientInfo(endpointUri, Optional.ofNullable(username), Optional.ofNullable(password), headers));
    }

    public static HawkularClientBuilder builder(String tenant) {
        return new HawkularClientBuilder(tenant);
    }

    public MetricsClient metrics() {
        return this.metricsClient;
    }

    public InventoryClient inventory() {
        return this.inventoryClient;
    }

    public AlertsClient alerts() {
        return this.alertsClient;
    }

    public ClientInfo getClientInfo() {
        return this.clientInfo;
    }

    public String getTenant() {
        return (String)this.clientInfo.getHeaders().get(KEY_HEADER_TENANT);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HawkularClient that = (HawkularClient)o;
        return this.clientInfo != null ? this.clientInfo.equals(that.clientInfo) : that.clientInfo == null;
    }

    public int hashCode() {
        return this.clientInfo != null ? this.clientInfo.hashCode() : 0;
    }

    public String toString() {
        return "HawkularClient{metricsClient=" + this.metricsClient + ", inventoryClient=" + this.inventoryClient + ", alertsClient=" + this.alertsClient + ", clientInfo=" + this.clientInfo + '}';
    }
}

