/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.client.core.jaxrs;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.ext.Provider;
import org.hawkular.client.core.jaxrs.fasterxml.jackson.ClientObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class RequestLoggingFilter
implements ClientRequestFilter {
    private static final Logger LOG = LoggerFactory.getLogger(RequestLoggingFilter.class);
    private static final ObjectMapper OBJECT_MAPPER = new ClientObjectMapper();

    public void filter(ClientRequestContext requestContext) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> HTTP: {}", (Object)requestContext.getMethod());
            LOG.debug(">> URI: {}", (Object)requestContext.getUri());
            LOG.debug(">> Headers: {}", (Object)requestContext.getHeaders());
            LOG.debug(">> Data: {}", (Object)OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(requestContext.getEntity()));
        }
    }
}

