/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.client.core.jaxrs;

import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.hawkular.client.core.ClientInfo;
import org.hawkular.client.core.jaxrs.RequestHeadersFilter;
import org.hawkular.client.core.jaxrs.RequestLoggingFilter;
import org.hawkular.client.core.jaxrs.ResponseLoggingFilter;
import org.hawkular.client.core.jaxrs.fasterxml.jackson.HCJacksonJson2Provider;
import org.hawkular.client.core.jaxrs.fasterxml.jackson.JacksonObjectMapperProvider;
import org.hawkular.client.core.jaxrs.param.ConvertersProvider;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ProxyBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient4Engine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestFactory<T> {
    private static final Logger _logger = LoggerFactory.getLogger(RestFactory.class);
    private final ClassLoader classLoader;
    private Class<T> apiClassType;

    public RestFactory(Class<T> clz) {
        this.classLoader = null;
        this.apiClassType = clz;
    }

    public RestFactory(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public T createAPI(ClientInfo clientInfo) {
        ResteasyClient client;
        Object httpclient = clientInfo.getEndpointUri().toString().startsWith("https") ? this.getHttpClient() : HttpClientBuilder.create().build();
        if (clientInfo.getUsername().isPresent() && clientInfo.getPassword().isPresent()) {
            HttpHost targetHost = new HttpHost(clientInfo.getEndpointUri().getHost(), clientInfo.getEndpointUri().getPort());
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(targetHost.getHostName(), targetHost.getPort()), (Credentials)new UsernamePasswordCredentials(clientInfo.getUsername().get(), clientInfo.getPassword().get()));
            BasicAuthCache authCache = new BasicAuthCache();
            BasicScheme basicAuth = new BasicScheme();
            authCache.put(targetHost, (AuthScheme)basicAuth);
            HttpClientContext context = HttpClientContext.create();
            context.setCredentialsProvider((CredentialsProvider)credsProvider);
            context.setAuthCache((AuthCache)authCache);
            ApacheHttpClient4Engine engine = new ApacheHttpClient4Engine(httpclient, (HttpContext)context);
            client = new ResteasyClientBuilder().httpEngine((ClientHttpEngine)engine).build();
        } else {
            ApacheHttpClient4Engine engine = new ApacheHttpClient4Engine(this.getHttpClient());
            client = new ResteasyClientBuilder().httpEngine((ClientHttpEngine)engine).build();
        }
        client.register(JacksonJaxbJsonProvider.class);
        client.register(JacksonObjectMapperProvider.class);
        client.register(RequestLoggingFilter.class);
        client.register((Object)new RequestHeadersFilter(clientInfo.getHeaders()));
        client.register(ResponseLoggingFilter.class);
        client.register(HCJacksonJson2Provider.class);
        client.register(ConvertersProvider.class);
        ProxyBuilder proxyBuilder = client.target(clientInfo.getEndpointUri()).proxyBuilder(this.apiClassType);
        if (this.classLoader != null) {
            proxyBuilder = proxyBuilder.classloader(this.classLoader);
        }
        return (T)proxyBuilder.build();
    }

    private HttpClient getHttpClient() {
        CloseableHttpClient httpclient = null;
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            SSLContextBuilder builder = new SSLContextBuilder();
            builder.loadTrustMaterial(keyStore, (org.apache.http.ssl.TrustStrategy)((TrustStrategy)(trustedCert, nameConstraints) -> true));
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(builder.build());
            httpclient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            _logger.error("Failed to create HTTPClient: {}", (Throwable)e);
        }
        return httpclient;
    }
}

