/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.client.core.jaxrs.fasterxml.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import org.hawkular.client.metrics.fasterxml.jackson.AvailabilityBucketPointMixin;
import org.hawkular.client.metrics.fasterxml.jackson.AvailabilityTypeMixin;
import org.hawkular.client.metrics.fasterxml.jackson.MetricTypeMixin;
import org.hawkular.client.metrics.fasterxml.jackson.NumericBucketPointMixin;
import org.hawkular.client.metrics.fasterxml.jackson.TaggedBucketPointMixin;
import org.hawkular.client.metrics.fasterxml.jackson.TenantMixin;
import org.hawkular.inventory.json.InventoryJacksonConfig;
import org.hawkular.metrics.model.AvailabilityBucketPoint;
import org.hawkular.metrics.model.AvailabilityType;
import org.hawkular.metrics.model.MetricType;
import org.hawkular.metrics.model.NumericBucketPoint;
import org.hawkular.metrics.model.TaggedBucketPoint;
import org.hawkular.metrics.model.Tenant;

public class ClientObjectMapper
extends ObjectMapper {
    private static final long serialVersionUID = 1L;

    public ClientObjectMapper() {
        ClientObjectMapper.config(this);
    }

    public static ObjectMapper config(ObjectMapper mapper) {
        mapper.configure(SerializationFeature.INDENT_OUTPUT, true).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setSerializationInclusion(JsonInclude.Include.NON_NULL);
        ClientObjectMapper.addMetricMixins(mapper);
        ClientObjectMapper.addInventoryMixins(mapper);
        return mapper;
    }

    private static void addMetricMixins(ObjectMapper mapper) {
        mapper.addMixIn(Tenant.class, TenantMixin.class).addMixIn(MetricType.class, MetricTypeMixin.class).addMixIn(AvailabilityType.class, AvailabilityTypeMixin.class).addMixIn(TaggedBucketPoint.class, TaggedBucketPointMixin.class).addMixIn(NumericBucketPoint.class, NumericBucketPointMixin.class).addMixIn(AvailabilityBucketPoint.class, AvailabilityBucketPointMixin.class);
    }

    private static void addInventoryMixins(ObjectMapper mapper) {
        InventoryJacksonConfig.configure((ObjectMapper)mapper);
    }
}

