/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.client.inventory;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import org.hawkular.client.core.ClientInfo;
import org.hawkular.client.inventory.InventoryClient;
import org.hawkular.client.inventory.clients.APIInfoClient;
import org.hawkular.client.inventory.clients.BulkCreateClient;
import org.hawkular.client.inventory.clients.DefaultAPIInfoClient;
import org.hawkular.client.inventory.clients.DefaultBulkCreateClient;
import org.hawkular.client.inventory.clients.DefaultEventsClient;
import org.hawkular.client.inventory.clients.DefaultGraphClient;
import org.hawkular.client.inventory.clients.DefaultSingleEntityClient;
import org.hawkular.client.inventory.clients.DefaultSyncClient;
import org.hawkular.client.inventory.clients.DefaultTenantClient;
import org.hawkular.client.inventory.clients.DefaultTraversalClient;
import org.hawkular.client.inventory.clients.EventsClient;
import org.hawkular.client.inventory.clients.GraphClient;
import org.hawkular.client.inventory.clients.SingleEntityClient;
import org.hawkular.client.inventory.clients.SyncClient;
import org.hawkular.client.inventory.clients.TenantClient;
import org.hawkular.client.inventory.clients.TraversalClient;

public class InventoryClientImpl
implements InventoryClient {
    private final APIInfoClient apiInfo;
    private final BulkCreateClient bulkCreate;
    private final TraversalClient traversal;
    private final EventsClient events;
    private final GraphClient graph;
    private final SingleEntityClient singleEntity;
    private final SyncClient sync;
    private final TenantClient tenant;

    public InventoryClientImpl(ClientInfo clientInfo) {
        Preconditions.checkNotNull((Object)clientInfo);
        this.apiInfo = new DefaultAPIInfoClient(clientInfo);
        this.bulkCreate = new DefaultBulkCreateClient(clientInfo);
        this.traversal = new DefaultTraversalClient(clientInfo);
        this.events = new DefaultEventsClient(clientInfo);
        this.graph = new DefaultGraphClient(clientInfo);
        this.singleEntity = new DefaultSingleEntityClient(clientInfo);
        this.sync = new DefaultSyncClient(clientInfo);
        this.tenant = new DefaultTenantClient(clientInfo);
    }

    @Override
    public APIInfoClient apiInfo() {
        return this.apiInfo;
    }

    @Override
    public BulkCreateClient bulkCreate() {
        return this.bulkCreate;
    }

    @Override
    public TraversalClient traversal() {
        return this.traversal;
    }

    @Override
    public EventsClient events() {
        return this.events;
    }

    @Override
    public GraphClient graph() {
        return this.graph;
    }

    @Override
    public SingleEntityClient singleEntity() {
        return this.singleEntity;
    }

    @Override
    public SyncClient sync() {
        return this.sync;
    }

    @Override
    public TenantClient tenant() {
        return this.tenant;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("apiInfo", (Object)this.apiInfo).add("bulkCreate", (Object)this.bulkCreate).add("traversal", (Object)this.traversal).add("events", (Object)this.events).add("graph", (Object)this.graph).add("singleEntity", (Object)this.singleEntity).add("sync", (Object)this.sync).add("tenant", (Object)this.tenant).toString();
    }
}

