/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.client.inventory.model;

import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.DataEntity;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.MetadataPack;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.OperationType;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.paths.SegmentType;

public enum ElementType {
    environment(Environment.class, Environment.Blueprint.class, SegmentType.e),
    resourceType(ResourceType.class, ResourceType.Blueprint.class, SegmentType.rt),
    metricType(MetricType.class, MetricType.Blueprint.class, SegmentType.mt),
    operationType(OperationType.class, OperationType.Blueprint.class, SegmentType.ot),
    feed(Feed.class, Feed.Blueprint.class, SegmentType.f),
    metric(Metric.class, Metric.Blueprint.class, SegmentType.m),
    resource(Resource.class, Resource.Blueprint.class, SegmentType.r),
    dataEntity(DataEntity.class, DataEntity.Blueprint.class, SegmentType.d),
    metadataPack(MetadataPack.class, MetadataPack.Blueprint.class, SegmentType.mp),
    relationship(Relationship.class, Relationship.Blueprint.class, SegmentType.r);

    final Class<? extends AbstractElement<?, ?>> elementType;
    final Class<? extends AbstractElement.Blueprint> blueprintType;
    final SegmentType segmentType;

    private ElementType(Class<? extends AbstractElement<?, ?>> elementType, Class<? extends AbstractElement.Blueprint> blueprintType, SegmentType segmentType) {
        this.elementType = elementType;
        this.blueprintType = blueprintType;
        this.segmentType = segmentType;
    }

    public static ElementType ofSegmentType(SegmentType type) {
        for (ElementType et : ElementType.values()) {
            if (!et.segmentType.equals((Object)type)) continue;
            return et;
        }
        return null;
    }

    public static ElementType ofBlueprintType(Class<?> type) {
        for (ElementType et : ElementType.values()) {
            if (!et.blueprintType.equals(type)) continue;
            return et;
        }
        return null;
    }
}

