/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.client.metrics;

import com.google.common.base.Preconditions;
import org.hawkular.client.core.ClientInfo;
import org.hawkular.client.metrics.MetricsClient;
import org.hawkular.client.metrics.clients.AvailabilityClient;
import org.hawkular.client.metrics.clients.CounterClient;
import org.hawkular.client.metrics.clients.DefaultAvailabilityClient;
import org.hawkular.client.metrics.clients.DefaultCounterClient;
import org.hawkular.client.metrics.clients.DefaultGaugeClient;
import org.hawkular.client.metrics.clients.DefaultMetricClient;
import org.hawkular.client.metrics.clients.DefaultPingClient;
import org.hawkular.client.metrics.clients.DefaultStatusClient;
import org.hawkular.client.metrics.clients.DefaultStringClient;
import org.hawkular.client.metrics.clients.DefaultTenantClient;
import org.hawkular.client.metrics.clients.GaugeClient;
import org.hawkular.client.metrics.clients.MetricClient;
import org.hawkular.client.metrics.clients.PingClient;
import org.hawkular.client.metrics.clients.StatusClient;
import org.hawkular.client.metrics.clients.StringClient;
import org.hawkular.client.metrics.clients.TenantClient;

public class MetricsClientImpl
implements MetricsClient {
    private final AvailabilityClient availability;
    private final CounterClient counter;
    private final GaugeClient gauge;
    private final DefaultMetricClient metric;
    private final DefaultStringClient string;
    private final DefaultTenantClient tenant;
    private final DefaultPingClient ping;
    private final DefaultStatusClient status;

    public MetricsClientImpl(ClientInfo clientInfo) {
        Preconditions.checkNotNull((Object)clientInfo);
        this.availability = new DefaultAvailabilityClient(clientInfo);
        this.counter = new DefaultCounterClient(clientInfo);
        this.gauge = new DefaultGaugeClient(clientInfo);
        this.metric = new DefaultMetricClient(clientInfo);
        this.string = new DefaultStringClient(clientInfo);
        this.tenant = new DefaultTenantClient(clientInfo);
        this.ping = new DefaultPingClient(clientInfo);
        this.status = new DefaultStatusClient(clientInfo);
    }

    @Override
    public AvailabilityClient availability() {
        return this.availability;
    }

    @Override
    public CounterClient counter() {
        return this.counter;
    }

    @Override
    public GaugeClient gauge() {
        return this.gauge;
    }

    @Override
    public MetricClient metric() {
        return this.metric;
    }

    @Override
    public StringClient string() {
        return this.string;
    }

    @Override
    public TenantClient tenant() {
        return this.tenant;
    }

    @Override
    public PingClient ping() {
        return this.ping;
    }

    @Override
    public StatusClient status() {
        return this.status;
    }
}

