/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.bus.common;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;

public class BinaryData
extends InputStream {
    private InputStream backingStream;
    private Runnable onCloseAction;

    public BinaryData(byte[] inMemoryData, InputStream streamData) {
        if (null == inMemoryData || inMemoryData.length == 0) {
            this.backingStream = streamData;
        } else {
            ByteArrayInputStream firstStream = new ByteArrayInputStream(inMemoryData);
            this.backingStream = new SequenceInputStream(firstStream, streamData);
        }
        this.onCloseAction = null;
    }

    public void setOnCloseAction(Runnable action) {
        this.onCloseAction = action;
    }

    @Override
    public void close() throws IOException {
        try {
            this.backingStream.close();
        }
        finally {
            if (this.onCloseAction != null) {
                this.onCloseAction.run();
            }
        }
    }

    @Override
    public void mark(int readlimit) {
        this.backingStream.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.backingStream.reset();
    }

    @Override
    public boolean markSupported() {
        return this.backingStream.markSupported();
    }

    @Override
    public int read() throws IOException {
        return this.backingStream.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.backingStream.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.backingStream.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.backingStream.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.backingStream.available();
    }
}

