/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.bus.restclient;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.hawkular.bus.restclient.RestClientException;
import org.jboss.logging.Logger;

public class RestClient {
    private static final String DEFAULT_URL_PATH = "/hawkular-bus/message/";
    private static final Logger LOG = Logger.getLogger(RestClient.class);
    private final URL endpoint;
    private final DefaultHttpClient httpclient;

    public RestClient(String host, Integer port) throws RestClientException {
        this("http", host, port);
    }

    public RestClient(String protocol, String host, Integer port) throws RestClientException {
        this(RestClient.buildDefaultURL(protocol, host, port));
    }

    private static URL buildDefaultURL(String protocol, String host, Integer port) throws RestClientException {
        try {
            return new URL(protocol, host, port != null ? port : -1, DEFAULT_URL_PATH);
        }
        catch (MalformedURLException e) {
            throw new RestClientException(e);
        }
    }

    public RestClient(URL endpoint) throws RestClientException {
        this.endpoint = endpoint.toString().endsWith("/") ? endpoint : this.appendToURL(endpoint, "/");
        this.getEndpointForType(Type.QUEUE, "Test");
        this.getEndpointForType(Type.TOPIC, "Test");
        this.httpclient = new DefaultHttpClient();
        LOG.debugf("Created Hawkular Bus REST client for endpoint [%s]", (Object)this.endpoint);
    }

    public URL getEndpoint() {
        return this.endpoint;
    }

    public HttpResponse postTopicMessage(String topicName, String jsonPayload, Map<String, String> headers) throws RestClientException {
        return this.postMessage(Type.TOPIC, topicName, jsonPayload, headers);
    }

    public HttpResponse postQueueMessage(String queueName, String jsonPayload, Map<String, String> headers) throws RestClientException {
        return this.postMessage(Type.QUEUE, queueName, jsonPayload, headers);
    }

    protected HttpResponse postMessage(Type type, String name, String jsonPayload, Map<String, String> headers) throws RestClientException {
        URI uri;
        URL messageUrl = this.getEndpointForType(type, name);
        try {
            uri = messageUrl.toURI();
        }
        catch (URISyntaxException e) {
            throw new RestClientException(e);
        }
        HttpResponse response = this.sendPost(uri, jsonPayload, headers);
        return response;
    }

    protected HttpResponse sendPost(URI uri, String jsonPayload, Map<String, String> headers) throws RestClientException {
        LOG.tracef("Posting message to bus. uri=[%s], json=[%s], headers[%s]", (Object)uri, (Object)jsonPayload, headers);
        HttpPost request = null;
        CloseableHttpResponse httpResponse = null;
        try {
            request = new HttpPost(uri);
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    request.setHeader(entry.getKey(), entry.getValue());
                }
            }
            request.setEntity((HttpEntity)new StringEntity(jsonPayload, ContentType.APPLICATION_JSON));
            httpResponse = this.httpclient.execute((HttpUriRequest)request);
            StatusLine statusLine = httpResponse.getStatusLine();
            if (statusLine.getStatusCode() != 200) {
                throw new Exception("HTTP post request failed. status-code=[" + statusLine.getStatusCode() + "], reason=[" + statusLine.getReasonPhrase() + "], url=[" + request.getURI() + "]");
            }
            CloseableHttpResponse closeableHttpResponse = httpResponse;
            return closeableHttpResponse;
        }
        catch (Exception e) {
            String string = String.format("Failed to post message to bus via URI [%s]", uri.toString());
            LOG.debugf("%s. Cause=[%s]", (Object)string, (Object)e.toString());
            throw new RestClientException((HttpResponse)httpResponse, string, e);
        }
        finally {
            if (request != null) {
                request.releaseConnection();
            }
        }
    }

    protected URL getEndpointForType(Type type, String name) throws RestClientException {
        switch (type) {
            case QUEUE: {
                return this.appendToURL(this.endpoint, name + "?type=queue");
            }
            case TOPIC: {
                return this.appendToURL(this.endpoint, name + "?type=topic");
            }
        }
        throw new RuntimeException("Invalid type [" + (Object)((Object)type) + "] - please report this bug");
    }

    protected URL appendToURL(URL url, String appendage) throws RestClientException {
        String oldUrlString = url.toString();
        String newUrlString = oldUrlString + appendage;
        try {
            return new URL(newUrlString);
        }
        catch (MalformedURLException e) {
            throw new RestClientException(String.format("URL [%s] cannot be appended with [%s]", url, appendage), (Throwable)e);
        }
    }

    public static enum Type {
        QUEUE,
        TOPIC;

    }
}

