
package org.hawkular.cmdgw.api;

import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * Deploys an application to an Application Server instance given by the inventory path stored in resourcePath field. The actual deployment file content must be appended to this JSON message.
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "destinationFileName",
    "enabled",
    "serverGroups"
})
public class DeployApplicationRequest
    extends ResourcePathRequest
    implements ResourcePathDestination
{

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("destinationFileName")
    private String destinationFileName;
    /**
     * If true, the deployment will be enabled immediately. If false, it will initially be disabled.
     * 
     */
    @JsonProperty("enabled")
    private Boolean enabled;
    /**
     * Comma-separated list of domain server groups where the application is to be deployed. This is ignored if not deploying in a domain.
     * 
     */
    @JsonProperty("serverGroups")
    private String serverGroups;

    /**
     * 
     * (Required)
     * 
     * @return
     *     The destinationFileName
     */
    @JsonProperty("destinationFileName")
    public String getDestinationFileName() {
        return destinationFileName;
    }

    /**
     * 
     * (Required)
     * 
     * @param destinationFileName
     *     The destinationFileName
     */
    @JsonProperty("destinationFileName")
    public void setDestinationFileName(String destinationFileName) {
        this.destinationFileName = destinationFileName;
    }

    /**
     * If true, the deployment will be enabled immediately. If false, it will initially be disabled.
     * 
     * @return
     *     The enabled
     */
    @JsonProperty("enabled")
    public Boolean getEnabled() {
        return enabled;
    }

    /**
     * If true, the deployment will be enabled immediately. If false, it will initially be disabled.
     * 
     * @param enabled
     *     The enabled
     */
    @JsonProperty("enabled")
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    /**
     * Comma-separated list of domain server groups where the application is to be deployed. This is ignored if not deploying in a domain.
     * 
     * @return
     *     The serverGroups
     */
    @JsonProperty("serverGroups")
    public String getServerGroups() {
        return serverGroups;
    }

    /**
     * Comma-separated list of domain server groups where the application is to be deployed. This is ignored if not deploying in a domain.
     * 
     * @param serverGroups
     *     The serverGroups
     */
    @JsonProperty("serverGroups")
    public void setServerGroups(String serverGroups) {
        this.serverGroups = serverGroups;
    }

}
