
package org.hawkular.cmdgw.api;

import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * If enabled, disable the deployment with destinationFileName, on the Application Server instance given by the inventory path stored in resourcePath field.
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "destinationFileName",
    "serverGroups"
})
public class DisableApplicationRequest
    extends ResourcePathRequest
    implements ResourcePathDestination
{

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("destinationFileName")
    private String destinationFileName;
    /**
     * Comma-separated list of domain server groups where the application is to be disabled. This is ignored if not disabling from a domain.
     * 
     */
    @JsonProperty("serverGroups")
    private String serverGroups;

    /**
     * 
     * (Required)
     * 
     * @return
     *     The destinationFileName
     */
    @JsonProperty("destinationFileName")
    public String getDestinationFileName() {
        return destinationFileName;
    }

    /**
     * 
     * (Required)
     * 
     * @param destinationFileName
     *     The destinationFileName
     */
    @JsonProperty("destinationFileName")
    public void setDestinationFileName(String destinationFileName) {
        this.destinationFileName = destinationFileName;
    }

    /**
     * Comma-separated list of domain server groups where the application is to be disabled. This is ignored if not disabling from a domain.
     * 
     * @return
     *     The serverGroups
     */
    @JsonProperty("serverGroups")
    public String getServerGroups() {
        return serverGroups;
    }

    /**
     * Comma-separated list of domain server groups where the application is to be disabled. This is ignored if not disabling from a domain.
     * 
     * @param serverGroups
     *     The serverGroups
     */
    @JsonProperty("serverGroups")
    public void setServerGroups(String serverGroups) {
        this.serverGroups = serverGroups;
    }

}
