
package org.hawkular.cmdgw.api;

import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * Undeploys an application from an Application Server instance given by the inventory path stored in resourcePath field.
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "destinationFileName",
    "serverGroups",
    "removeContent"
})
public class UndeployApplicationRequest
    extends ResourcePathRequest
    implements ResourcePathDestination
{

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("destinationFileName")
    private String destinationFileName;
    /**
     * Comma-separated list of domain server groups where the application is to be undeployed. This is ignored if not undeploying from a domain.
     * 
     */
    @JsonProperty("serverGroups")
    private String serverGroups;
    /**
     * If true the application content is removed from internal storage. If false, the content remains allowing for faster redeployment.
     * 
     */
    @JsonProperty("removeContent")
    private Boolean removeContent;

    /**
     * 
     * (Required)
     * 
     * @return
     *     The destinationFileName
     */
    @JsonProperty("destinationFileName")
    public String getDestinationFileName() {
        return destinationFileName;
    }

    /**
     * 
     * (Required)
     * 
     * @param destinationFileName
     *     The destinationFileName
     */
    @JsonProperty("destinationFileName")
    public void setDestinationFileName(String destinationFileName) {
        this.destinationFileName = destinationFileName;
    }

    /**
     * Comma-separated list of domain server groups where the application is to be undeployed. This is ignored if not undeploying from a domain.
     * 
     * @return
     *     The serverGroups
     */
    @JsonProperty("serverGroups")
    public String getServerGroups() {
        return serverGroups;
    }

    /**
     * Comma-separated list of domain server groups where the application is to be undeployed. This is ignored if not undeploying from a domain.
     * 
     * @param serverGroups
     *     The serverGroups
     */
    @JsonProperty("serverGroups")
    public void setServerGroups(String serverGroups) {
        this.serverGroups = serverGroups;
    }

    /**
     * If true the application content is removed from internal storage. If false, the content remains allowing for faster redeployment.
     * 
     * @return
     *     The removeContent
     */
    @JsonProperty("removeContent")
    public Boolean getRemoveContent() {
        return removeContent;
    }

    /**
     * If true the application content is removed from internal storage. If false, the content remains allowing for faster redeployment.
     * 
     * @param removeContent
     *     The removeContent
     */
    @JsonProperty("removeContent")
    public void setRemoveContent(Boolean removeContent) {
        this.removeContent = removeContent;
    }

}
