
package org.hawkular.cmdgw.api;

import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * Adds a JDBC Driver to an Application Server instance given by the inventory path stored in resourcePath field. The driver module is created only if driverJarName is set (in such a case, the jar file content must be appended to this JSON message). Otherwise, the existence of the module given by moduleName and default slot "main" will be assumed.
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "driverName",
    "driverClass",
    "driverXaDatasourceClassName",
    "jdbcCompliant",
    "driverMajorVersion",
    "driverMinorVersion",
    "moduleName",
    "driverJarName"
})
public class AddJdbcDriverRequest
    extends ResourcePathRequest
    implements ResourcePathDestination
{

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("driverName")
    private String driverName;
    @JsonProperty("driverClass")
    private String driverClass;
    @JsonProperty("driverXaDatasourceClassName")
    private String driverXaDatasourceClassName;
    @JsonProperty("jdbcCompliant")
    private Boolean jdbcCompliant;
    @JsonProperty("driverMajorVersion")
    private Integer driverMajorVersion;
    @JsonProperty("driverMinorVersion")
    private Integer driverMinorVersion;
    /**
     * The name of the JBoss Module to create or use, such as "org.example.jdbc.driver"
     * (Required)
     * 
     */
    @JsonProperty("moduleName")
    private String moduleName;
    /**
     * The name of the jar file that should be used when storing the binary data to in the module directory on the server. If this field is set the jar bits must be appended to this JSON message. If this field is set, the module will be created, otherwise the existence of the module given by moduleName and default slot "main" will be assumed.
     * 
     */
    @JsonProperty("driverJarName")
    private String driverJarName;

    /**
     * 
     * (Required)
     * 
     * @return
     *     The driverName
     */
    @JsonProperty("driverName")
    public String getDriverName() {
        return driverName;
    }

    /**
     * 
     * (Required)
     * 
     * @param driverName
     *     The driverName
     */
    @JsonProperty("driverName")
    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    /**
     * 
     * @return
     *     The driverClass
     */
    @JsonProperty("driverClass")
    public String getDriverClass() {
        return driverClass;
    }

    /**
     * 
     * @param driverClass
     *     The driverClass
     */
    @JsonProperty("driverClass")
    public void setDriverClass(String driverClass) {
        this.driverClass = driverClass;
    }

    /**
     * 
     * @return
     *     The driverXaDatasourceClassName
     */
    @JsonProperty("driverXaDatasourceClassName")
    public String getDriverXaDatasourceClassName() {
        return driverXaDatasourceClassName;
    }

    /**
     * 
     * @param driverXaDatasourceClassName
     *     The driverXaDatasourceClassName
     */
    @JsonProperty("driverXaDatasourceClassName")
    public void setDriverXaDatasourceClassName(String driverXaDatasourceClassName) {
        this.driverXaDatasourceClassName = driverXaDatasourceClassName;
    }

    /**
     * 
     * @return
     *     The jdbcCompliant
     */
    @JsonProperty("jdbcCompliant")
    public Boolean getJdbcCompliant() {
        return jdbcCompliant;
    }

    /**
     * 
     * @param jdbcCompliant
     *     The jdbcCompliant
     */
    @JsonProperty("jdbcCompliant")
    public void setJdbcCompliant(Boolean jdbcCompliant) {
        this.jdbcCompliant = jdbcCompliant;
    }

    /**
     * 
     * @return
     *     The driverMajorVersion
     */
    @JsonProperty("driverMajorVersion")
    public Integer getDriverMajorVersion() {
        return driverMajorVersion;
    }

    /**
     * 
     * @param driverMajorVersion
     *     The driverMajorVersion
     */
    @JsonProperty("driverMajorVersion")
    public void setDriverMajorVersion(Integer driverMajorVersion) {
        this.driverMajorVersion = driverMajorVersion;
    }

    /**
     * 
     * @return
     *     The driverMinorVersion
     */
    @JsonProperty("driverMinorVersion")
    public Integer getDriverMinorVersion() {
        return driverMinorVersion;
    }

    /**
     * 
     * @param driverMinorVersion
     *     The driverMinorVersion
     */
    @JsonProperty("driverMinorVersion")
    public void setDriverMinorVersion(Integer driverMinorVersion) {
        this.driverMinorVersion = driverMinorVersion;
    }

    /**
     * The name of the JBoss Module to create or use, such as "org.example.jdbc.driver"
     * (Required)
     * 
     * @return
     *     The moduleName
     */
    @JsonProperty("moduleName")
    public String getModuleName() {
        return moduleName;
    }

    /**
     * The name of the JBoss Module to create or use, such as "org.example.jdbc.driver"
     * (Required)
     * 
     * @param moduleName
     *     The moduleName
     */
    @JsonProperty("moduleName")
    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    /**
     * The name of the jar file that should be used when storing the binary data to in the module directory on the server. If this field is set the jar bits must be appended to this JSON message. If this field is set, the module will be created, otherwise the existence of the module given by moduleName and default slot "main" will be assumed.
     * 
     * @return
     *     The driverJarName
     */
    @JsonProperty("driverJarName")
    public String getDriverJarName() {
        return driverJarName;
    }

    /**
     * The name of the jar file that should be used when storing the binary data to in the module directory on the server. If this field is set the jar bits must be appended to this JSON message. If this field is set, the module will be created, otherwise the existence of the module given by moduleName and default slot "main" will be assumed.
     * 
     * @param driverJarName
     *     The driverJarName
     */
    @JsonProperty("driverJarName")
    public void setDriverJarName(String driverJarName) {
        this.driverJarName = driverJarName;
    }

}
