/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.cmdgw.command.ws;

import java.util.ArrayList;
import java.util.Collection;
import javax.enterprise.context.ApplicationScoped;
import org.hawkular.bus.common.BasicMessage;
import org.hawkular.cmdgw.NoCommandForMessageException;
import org.hawkular.cmdgw.api.EchoRequest;
import org.hawkular.cmdgw.api.EventDestination;
import org.hawkular.cmdgw.api.ResourcePathDestination;
import org.hawkular.cmdgw.api.UiSessionDestination;
import org.hawkular.cmdgw.command.ws.EchoCommand;
import org.hawkular.cmdgw.command.ws.EventDestinationWsCommand;
import org.hawkular.cmdgw.command.ws.ResourcePathDestinationWsCommand;
import org.hawkular.cmdgw.command.ws.UiSessionDestinationWsCommand;
import org.hawkular.cmdgw.command.ws.WsCommand;

@ApplicationScoped
public class WsCommands {
    private final ResourcePathDestinationWsCommand resourcePathDestinationWsCommand = new ResourcePathDestinationWsCommand();
    private final EchoCommand echoCommand = new EchoCommand();
    private final UiSessionDestinationWsCommand uiSessionDestinationWsCommand = new UiSessionDestinationWsCommand();
    private final EventDestinationWsCommand eventDestinationWsCommand = new EventDestinationWsCommand();

    public <REQ extends BasicMessage> Collection<WsCommand<REQ>> getCommands(Class<REQ> requestClass) throws NoCommandForMessageException {
        ArrayList<WsCommand<REQ>> results = new ArrayList<WsCommand<REQ>>(2);
        if (ResourcePathDestination.class.isAssignableFrom(requestClass)) {
            results.add((WsCommand<REQ>)this.resourcePathDestinationWsCommand);
        } else if (UiSessionDestination.class.isAssignableFrom(requestClass)) {
            results.add((WsCommand<REQ>)this.uiSessionDestinationWsCommand);
        } else if (EchoRequest.class.isAssignableFrom(requestClass)) {
            results.add((WsCommand<REQ>)this.echoCommand);
        }
        if (EventDestination.class.isAssignableFrom(requestClass)) {
            results.add((WsCommand<REQ>)this.eventDestinationWsCommand);
        }
        if (results.isEmpty()) {
            throw new NoCommandForMessageException("No command found for requestClass [" + requestClass.getName() + "]");
        }
        return results;
    }
}

