/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.cmdgw.command.ws;

import java.util.Collections;
import org.hawkular.bus.common.BasicMessage;
import org.hawkular.bus.common.BasicMessageWithExtraData;
import org.hawkular.bus.common.ConnectionContextFactory;
import org.hawkular.bus.common.Endpoint;
import org.hawkular.bus.common.MessageId;
import org.hawkular.bus.common.MessageProcessor;
import org.hawkular.bus.common.producer.ProducerConnectionContext;
import org.hawkular.cmdgw.Constants;
import org.hawkular.cmdgw.api.GenericSuccessResponse;
import org.hawkular.cmdgw.api.ResourcePathDestination;
import org.hawkular.cmdgw.command.ws.WsCommand;
import org.hawkular.cmdgw.command.ws.WsCommandContext;
import org.hawkular.cmdgw.command.ws.server.WebSocketHelper;
import org.hawkular.cmdgw.log.GatewayLoggers;
import org.hawkular.cmdgw.log.MsgLogger;
import org.hawkular.inventory.paths.CanonicalPath;

public class ResourcePathDestinationWsCommand
implements WsCommand<ResourcePathDestination> {
    private static final MsgLogger log = GatewayLoggers.getLogger(ResourcePathDestinationWsCommand.class);

    public void execute(BasicMessageWithExtraData<ResourcePathDestination> message, WsCommandContext context) throws Exception {
        ResourcePathDestination request = (ResourcePathDestination)message.getBasicMessage();
        String rawResourcePath = request.getResourcePath();
        if (rawResourcePath == null) {
            throw new IllegalStateException(request.getClass().getName() + ".resourcePath must not be null");
        }
        log.tracef("[%s] is about to execute the request [%s] ", (Object)this.getClass().getName(), (Object)request);
        CanonicalPath resourcePath = CanonicalPath.fromString((String)rawResourcePath);
        String feedId = resourcePath.ids().getFeedId();
        try (ConnectionContextFactory ccf = new ConnectionContextFactory(context.getConnectionFactory());){
            Endpoint endpoint = Constants.FEED_COMMAND_QUEUE;
            ProducerConnectionContext pcc = ccf.createProducerConnectionContext(endpoint);
            MessageId mid = new MessageProcessor().send(pcc, message, Collections.singletonMap("feedId", feedId));
            log.debugf("Message [%s] forwarded to bus endpoint [%s]", (Object)request.getClass().getName(), (Object)endpoint.getName());
            GenericSuccessResponse response = new GenericSuccessResponse();
            response.setMessage("The request has been forwarded to feed [" + feedId + "] (MessageId=" + mid + ")");
            BasicMessageWithExtraData result = new BasicMessageWithExtraData((BasicMessage)response, null);
            new WebSocketHelper().sendSync(context.getSession(), result);
        }
    }
}

