/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.commons.email.internal;

import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Resource;
import javax.annotation.security.PermitAll;
import javax.ejb.Singleton;
import javax.inject.Inject;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.hawkular.commons.email.EmailDispatcher;
import org.hawkular.commons.email.internal.FromAddress;
import org.hawkular.commons.email.internal.MsgLogger;
import org.hawkular.commons.templates.TemplateService;

@PermitAll
@Singleton
public class EmailDispatcherImpl
implements EmailDispatcher {
    MsgLogger logger = MsgLogger.LOGGER;
    @Inject
    TemplateService templateService;
    @Resource(lookup="java:jboss/mail/Default")
    Session mailSession;
    @Inject
    @FromAddress
    InternetAddress fromAddress;

    @Override
    public boolean dispatch(InternetAddress recipient, String subject, String templatePlain, String templateHtml, Map<String, Object> properties) {
        MimeMessage message = new MimeMessage(this.mailSession);
        try {
            String processedContentPlain = this.templateService.getProcessedTemplate(templatePlain, Locale.US, properties);
            String processedContentHtml = this.templateService.getProcessedTemplate(templateHtml, Locale.US, properties);
            message.setFrom((Address)this.fromAddress);
            message.setRecipient(Message.RecipientType.TO, (Address)recipient);
            message.setSubject(subject);
            MimeBodyPart text = new MimeBodyPart();
            text.setContent((Object)processedContentPlain, "text/plain");
            MimeBodyPart rich = new MimeBodyPart();
            rich.setContent((Object)processedContentHtml, "text/html");
            MimeMultipart multipart = new MimeMultipart("alternative");
            multipart.addBodyPart((BodyPart)rich);
            multipart.addBodyPart((BodyPart)text);
            message.setContent((Multipart)multipart);
        }
        catch (TemplateException | IOException | MessagingException e) {
            this.logger.exceptionPreparingMessage(recipient.getAddress(), e);
            return false;
        }
        try {
            Transport.send((Message)message);
        }
        catch (MessagingException e) {
            this.logger.exceptionSendingMessage(recipient.getAddress(), e);
            return false;
        }
        return true;
    }
}

