/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.commons.templates.internal;

import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.security.PermitAll;
import javax.ejb.Singleton;
import javax.inject.Inject;
import org.hawkular.commons.templates.TemplateService;
import org.hawkular.commons.templates.internal.ConfigurationDirectory;
import org.hawkular.commons.templates.internal.OverrideDirectory;

@PermitAll
@Singleton
public class TemplateServiceImpl
implements TemplateService {
    @Inject
    @OverrideDirectory
    String overrideDirectory;
    @Inject
    @ConfigurationDirectory
    String configurationDirectory;
    private Configuration configuration = new Configuration(Configuration.VERSION_2_3_23);

    public TemplateServiceImpl() throws IOException {
        this(null, null);
    }

    public TemplateServiceImpl(String overrideDirectory, String configurationDirectory) throws IOException {
        if (null != overrideDirectory) {
            this.overrideDirectory = overrideDirectory;
        }
        if (null != configurationDirectory) {
            this.configurationDirectory = configurationDirectory;
        }
    }

    @Override
    public String getProcessedTemplate(String templateName, Locale locale, Map<String, Object> properties) throws IOException, TemplateException {
        Template template = this.configuration.getTemplate(templateName, locale);
        StringWriter writer = new StringWriter();
        template.process(properties, (Writer)writer);
        return writer.toString();
    }

    @PostConstruct
    void configure() throws IOException {
        LinkedHashSet<FileTemplateLoader> loaders = new LinkedHashSet<FileTemplateLoader>();
        if (null != this.overrideDirectory) {
            loaders.add(new FileTemplateLoader(new File(this.overrideDirectory)));
        }
        if (null != this.configurationDirectory) {
            loaders.add(new FileTemplateLoader(new File(this.configurationDirectory)));
        }
        MultiTemplateLoader mtl = new MultiTemplateLoader(loaders.toArray(new TemplateLoader[loaders.size()]));
        this.configuration.setDefaultEncoding("UTF-8");
        this.configuration.setTemplateLoader((TemplateLoader)mtl);
    }
}

