/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.paths;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hawkular.inventory.paths.ElementTypeVisitor;
import org.hawkular.inventory.paths.Path;
import org.hawkular.inventory.paths.RelativePath;
import org.hawkular.inventory.paths.SegmentType;

public final class CanonicalPath
extends Path
implements Iterable<CanonicalPath>,
Serializable {
    private static final long serialVersionUID = -333891787878559703L;
    static final Map<SegmentType, EnumSet<SegmentType>> VALID_PROGRESSIONS = new HashMap<SegmentType, EnumSet<SegmentType>>();

    private CanonicalPath() {
    }

    CanonicalPath(int myIdx, List<Path.Segment> path) {
        super(0, myIdx, path);
    }

    CanonicalPath(int startIdx, int myIdx, List<Path.Segment> path) {
        this(myIdx, path);
    }

    public static Extender empty() {
        return new Extender(0, new ArrayList<Path.Segment>());
    }

    public static Builder of() {
        return new Builder((List)new ArrayList());
    }

    public static CanonicalPath fromString(String path) {
        return CanonicalPath.fromPartiallyUntypedString(path, new Path.StructuredDataHintingTypeProvider());
    }

    public static CanonicalPath fromPartiallyUntypedString(String path, Path.TypeProvider typeProvider) {
        return (CanonicalPath)Path.fromString(path, true, Extender::new, new CanonicalTypeProvider(typeProvider));
    }

    public static CanonicalPath fromPartiallyUntypedString(String path, CanonicalPath initialPosition, Class<?> intendedFinalType) {
        return CanonicalPath.fromPartiallyUntypedString(path, initialPosition, SegmentType.fromElementType(intendedFinalType));
    }

    public static CanonicalPath fromPartiallyUntypedString(String path, CanonicalPath initialPosition, SegmentType intendedFinalType) {
        Path.ExtenderConstructor ctor = (idx, list) -> {
            if (initialPosition != null) {
                list.addAll(initialPosition.getPath());
            }
            return new Extender(idx, list);
        };
        return (CanonicalPath)Path.fromString(path, true, ctor, new CanonicalTypeProvider(new Path.HintedTypeProvider(intendedFinalType, new Extender(0, initialPosition == null ? new ArrayList<Path.Segment>() : new ArrayList<Path.Segment>(initialPosition.getPath())))));
    }

    public <R, P> R accept(ElementTypeVisitor<R, P> visitor, P parameter) {
        return this.getSegment().accept(visitor, parameter);
    }

    @Override
    public CanonicalPath toCanonicalPath() {
        return this;
    }

    @Override
    public RelativePath toRelativePath() {
        return ((RelativePath.Extender)RelativePath.empty().extend(this.getPath())).get();
    }

    public Iterator<CanonicalPath> ascendingIterator() {
        return super.ascendingIterator();
    }

    public Iterator<CanonicalPath> descendingIterator() {
        return super.descendingIterator();
    }

    @Override
    public CanonicalPath down() {
        return (CanonicalPath)super.down();
    }

    @Override
    public CanonicalPath down(int distance) {
        return (CanonicalPath)super.down(distance);
    }

    @Override
    protected CanonicalPath newInstance(int startIdx, int endIdx, List<Path.Segment> segments) {
        return new CanonicalPath(startIdx, endIdx, segments);
    }

    @Override
    public CanonicalPath up() {
        return (CanonicalPath)super.up();
    }

    @Override
    public CanonicalPath up(int distance) {
        return (CanonicalPath)super.up(distance);
    }

    public CanonicalPath getRoot() {
        return new CanonicalPath(1, this.path);
    }

    public CanonicalPath getLeaf() {
        return new CanonicalPath(this.path.size(), this.path);
    }

    public boolean isParentOf(CanonicalPath other) {
        return super.isParentOf(other);
    }

    public RelativePath relativeTo(CanonicalPath root) {
        int commonPrefixLength;
        if (root == null) {
            throw new IllegalArgumentException("root == null");
        }
        int maxCommonPrefixLength = Math.min(this.endIdx, root.endIdx);
        for (commonPrefixLength = 0; commonPrefixLength < maxCommonPrefixLength && ((Path.Segment)this.path.get(commonPrefixLength)).equals(root.path.get(commonPrefixLength)); ++commonPrefixLength) {
        }
        RelativePath.Extender ret = RelativePath.empty();
        for (int ups = root.endIdx; ups > commonPrefixLength; --ups) {
            ret = ret.extendUp();
        }
        for (int downs = commonPrefixLength; downs < this.endIdx; ++downs) {
            ret.extend((Path.Segment)this.path.get(downs));
        }
        return ret.get();
    }

    public Extender extend(SegmentType type, String id) {
        return this.modified().extend(new Path.Segment(type, id));
    }

    @Override
    public Extender modified() {
        return new Extender(this.startIdx, new ArrayList<Path.Segment>(this.path.subList(0, this.endIdx)));
    }

    public IdExtractor ids() {
        return new IdExtractor();
    }

    @Override
    public String toString() {
        return new Path.Encoder(x -> true).encode(Character.toString('/'), this);
    }

    @Override
    public Iterator<CanonicalPath> iterator() {
        return this.ascendingIterator();
    }

    static {
        VALID_PROGRESSIONS.put(SegmentType.t, EnumSet.of(SegmentType.e, SegmentType.mt, SegmentType.rt, SegmentType.f, SegmentType.mp));
        VALID_PROGRESSIONS.put(SegmentType.e, EnumSet.of(SegmentType.m, SegmentType.r));
        VALID_PROGRESSIONS.put(SegmentType.f, EnumSet.of(SegmentType.m, SegmentType.r, SegmentType.mt, SegmentType.rt));
        VALID_PROGRESSIONS.put(SegmentType.rt, EnumSet.of(SegmentType.d, SegmentType.ot));
        VALID_PROGRESSIONS.put(SegmentType.ot, EnumSet.of(SegmentType.d));
        VALID_PROGRESSIONS.put(SegmentType.r, EnumSet.of(SegmentType.r, SegmentType.d, SegmentType.m));
        VALID_PROGRESSIONS.put(SegmentType.d, EnumSet.of(SegmentType.sd));
        VALID_PROGRESSIONS.put(SegmentType.sd, EnumSet.of(SegmentType.sd));
        VALID_PROGRESSIONS.put(null, EnumSet.of(SegmentType.t, SegmentType.rl));
    }

    private static class CanonicalTypeProvider
    extends Path.EnhancedTypeProvider {
        private final Path.TypeProvider wrapped;

        private CanonicalTypeProvider(Path.TypeProvider wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public void segmentParsed(Path.Segment segment) {
            if (this.wrapped != null) {
                this.wrapped.segmentParsed(segment);
            }
        }

        @Override
        public Path.Segment deduceSegment(String type, String id, boolean isLast) {
            if (type != null && !type.isEmpty()) {
                if (id == null || id.isEmpty()) {
                    return null;
                }
                return new Path.Segment(SegmentType.fastValueOf(type), id);
            }
            if (id == null || id.isEmpty()) {
                return null;
            }
            SegmentType cls = SegmentType.fastValueOf(id);
            if (cls == null && this.wrapped != null) {
                return this.wrapped.deduceSegment(type, id, isLast);
            }
            if (cls != null) {
                return new Path.Segment(cls, id);
            }
            return null;
        }

        @Override
        public void finished() {
            if (this.wrapped != null) {
                this.wrapped.finished();
            }
        }

        @Override
        Set<String> getValidTypeName() {
            return SegmentType.getCanonicalShortNames();
        }
    }

    public static class Extender
    extends Path.Extender {
        Extender(int from, List<Path.Segment> segments) {
            super(from, segments, true, s -> s.isEmpty() ? Arrays.asList(SegmentType.t, SegmentType.rl) : (Collection)VALID_PROGRESSIONS.get((Object)((Path.Segment)s.get(s.size() - 1)).getElementType()));
        }

        @Override
        protected CanonicalPath newPath(int startIdx, int endIdx, List<Path.Segment> segments) {
            return new CanonicalPath(startIdx, endIdx, segments);
        }

        @Override
        public Extender extend(Path.Segment segment) {
            return (Extender)super.extend(segment);
        }

        @Override
        public Extender extend(Collection<Path.Segment> segments) {
            return (Extender)super.extend(segments);
        }

        @Override
        public Extender extend(SegmentType type, String id) {
            return (Extender)super.extend(type, id);
        }

        @Override
        public CanonicalPath get() {
            return (CanonicalPath)super.get();
        }
    }

    public final class IdExtractor {
        public String getTenantId() {
            return this.idIfTypeCorrect(CanonicalPath.this.getRoot(), SegmentType.t);
        }

        public String getEnvironmentId() {
            return this.idIfTypeCorrect(CanonicalPath.this.getRoot().down(), SegmentType.e);
        }

        public String getMetricTypeId() {
            if (this.getFeedId() != null) {
                return this.idIfTypeCorrect(CanonicalPath.this.getRoot().down(2), SegmentType.mt);
            }
            return this.idIfTypeCorrect(CanonicalPath.this.getRoot().down(), SegmentType.mt);
        }

        public String getResourceTypeId() {
            if (this.getFeedId() != null) {
                return this.idIfTypeCorrect(CanonicalPath.this.getRoot().down(2), SegmentType.rt);
            }
            return this.idIfTypeCorrect(CanonicalPath.this.getRoot().down(), SegmentType.rt);
        }

        public String getFeedId() {
            return this.idIfTypeCorrect(CanonicalPath.this.getRoot().down(), SegmentType.f);
        }

        public RelativePath getResourcePath() {
            int to;
            int from;
            List path = CanonicalPath.this.path;
            for (from = CanonicalPath.this.startIdx; from < CanonicalPath.this.endIdx && !SegmentType.r.equals((Object)((Path.Segment)path.get(from)).getElementType()); ++from) {
            }
            if (from == path.size()) {
                return null;
            }
            for (to = from; to < CanonicalPath.this.endIdx && SegmentType.r.equals((Object)((Path.Segment)path.get(to)).getElementType()); ++to) {
            }
            return new RelativePath(from, to, CanonicalPath.this.path);
        }

        public String getMetricId() {
            return this.idIfTypeCorrect(CanonicalPath.this, SegmentType.m);
        }

        public String getRelationshipId() {
            return this.idIfTypeCorrect(CanonicalPath.this.getRoot(), SegmentType.rl);
        }

        public String getOperationTypeId() {
            if (this.getFeedId() != null) {
                return this.idIfTypeCorrect(CanonicalPath.this.getRoot().down(3), SegmentType.ot);
            }
            return this.idIfTypeCorrect(CanonicalPath.this.getRoot().down(2), SegmentType.ot);
        }

        public String getDataRole() {
            CanonicalPath currentPath = CanonicalPath.this;
            while (SegmentType.sd.equals((Object)currentPath.getSegment().getElementType())) {
                currentPath = currentPath.up();
            }
            String roleStr = this.idIfTypeCorrect(currentPath, SegmentType.d);
            return roleStr;
        }

        private String idIfTypeCorrect(CanonicalPath path, SegmentType desiredType) {
            if (path.isDefined() && path.getSegment().getElementType().equals((Object)desiredType)) {
                return path.getSegment().getElementId();
            }
            return null;
        }
    }

    public static final class StructuredDataBuilder
    extends Path.StructuredDataBuilder<CanonicalPath, StructuredDataBuilder> {
        private StructuredDataBuilder(List<Path.Segment> segments) {
            super(segments, CanonicalPath::new);
        }
    }

    public static final class RelationshipBuilder
    extends Path.RelationshipBuilder<CanonicalPath> {
        private RelationshipBuilder(List<Path.Segment> segments) {
            super(segments, CanonicalPath::new);
        }
    }

    public static final class FeedBuilder
    extends Path.FeedBuilder<CanonicalPath, ResourceTypeBuilder, MetricTypeBuilder, ResourceBuilder, MetricBuilder, OperationTypeBuilder, StructuredDataBuilder> {
        private FeedBuilder(List<Path.Segment> list) {
            super(list, CanonicalPath::new);
        }

        @Override
        protected ResourceTypeBuilder resourceTypeBuilder(List<Path.Segment> segments) {
            return new ResourceTypeBuilder((List)segments);
        }

        @Override
        protected MetricTypeBuilder metricTypeBuilder(List<Path.Segment> segments) {
            return new MetricTypeBuilder((List)segments);
        }

        @Override
        protected ResourceBuilder resourceBuilder(List<Path.Segment> segments) {
            return new ResourceBuilder((List)segments);
        }

        @Override
        protected MetricBuilder metricBuilder(List<Path.Segment> segments) {
            return new MetricBuilder((List)segments);
        }
    }

    public static final class MetricBuilder
    extends Path.MetricBuilder<CanonicalPath> {
        private MetricBuilder(List<Path.Segment> segments) {
            super(segments, CanonicalPath::new);
        }
    }

    public static final class ResourceBuilder
    extends Path.ResourceBuilder<CanonicalPath, ResourceBuilder, MetricBuilder, StructuredDataBuilder> {
        private ResourceBuilder(List<Path.Segment> segments) {
            super(segments, CanonicalPath::new);
        }

        @Override
        protected MetricBuilder metricBuilder(List<Path.Segment> segments) {
            return new MetricBuilder((List)segments);
        }

        @Override
        protected StructuredDataBuilder structuredDataBuilder(List<Path.Segment> segments) {
            return new StructuredDataBuilder((List)segments);
        }
    }

    public static final class OperationTypeBuilder
    extends Path.OperationTypeBuilder<CanonicalPath, StructuredDataBuilder> {
        private OperationTypeBuilder(List<Path.Segment> segments) {
            super(segments, CanonicalPath::new);
        }

        @Override
        protected StructuredDataBuilder structuredDataBuilder(List<Path.Segment> segments) {
            return new StructuredDataBuilder((List)segments);
        }
    }

    public static final class MetricTypeBuilder
    extends Path.MetricTypeBuilder<CanonicalPath> {
        private MetricTypeBuilder(List<Path.Segment> segments) {
            super(segments, CanonicalPath::new);
        }
    }

    public static final class ResourceTypeBuilder
    extends Path.ResourceTypeBuilder<CanonicalPath, OperationTypeBuilder, StructuredDataBuilder> {
        private ResourceTypeBuilder(List<Path.Segment> list) {
            super(list, CanonicalPath::new);
        }

        @Override
        protected OperationTypeBuilder operationTypeBuilder(List<Path.Segment> segments) {
            return new OperationTypeBuilder((List)segments);
        }

        @Override
        protected StructuredDataBuilder structuredDataBuilder(List<Path.Segment> segments) {
            return new StructuredDataBuilder((List)segments);
        }
    }

    public static final class EnvironmentBuilder
    extends Path.EnvironmentBuilder<CanonicalPath, ResourceBuilder, MetricBuilder, ResourceTypeBuilder, MetricTypeBuilder, OperationTypeBuilder, StructuredDataBuilder> {
        private EnvironmentBuilder(List<Path.Segment> list) {
            super(list, CanonicalPath::new);
        }

        @Override
        protected ResourceBuilder resourceBuilder(List<Path.Segment> segments) {
            return new ResourceBuilder((List)segments);
        }

        @Override
        protected MetricBuilder metricBuilder(List<Path.Segment> segments) {
            return new MetricBuilder((List)segments);
        }
    }

    public static final class MetadataPackBuilder
    extends Path.MetadataPackBuilder<CanonicalPath> {
        private MetadataPackBuilder(List<Path.Segment> segments) {
            super(segments, CanonicalPath::new);
        }
    }

    public static final class TenantBuilder
    extends Path.TenantBuilder<CanonicalPath, EnvironmentBuilder, ResourceTypeBuilder, MetricTypeBuilder, OperationTypeBuilder, StructuredDataBuilder, MetadataPackBuilder, FeedBuilder, ResourceBuilder, MetricBuilder> {
        private TenantBuilder(List<Path.Segment> list) {
            super(list, CanonicalPath::new);
        }

        @Override
        protected EnvironmentBuilder environmentBuilder(List<Path.Segment> list) {
            return new EnvironmentBuilder((List)list);
        }

        @Override
        protected FeedBuilder feedBuilder(List<Path.Segment> segments) {
            return new FeedBuilder((List)segments);
        }

        @Override
        protected ResourceTypeBuilder resourceTypeBuilder(List<Path.Segment> list) {
            return new ResourceTypeBuilder((List)list);
        }

        @Override
        protected MetricTypeBuilder metricTypeBuilder(List<Path.Segment> list) {
            return new MetricTypeBuilder((List)list);
        }

        @Override
        protected MetadataPackBuilder metadataPackBuilder(List<Path.Segment> segments) {
            return new MetadataPackBuilder((List)segments);
        }
    }

    public static final class Builder
    extends Path.Builder<CanonicalPath, TenantBuilder, EnvironmentBuilder, ResourceTypeBuilder, MetricTypeBuilder, RelationshipBuilder, OperationTypeBuilder, StructuredDataBuilder, MetadataPackBuilder, FeedBuilder, ResourceBuilder, MetricBuilder> {
        private Builder(List<Path.Segment> list) {
            super(list, CanonicalPath::new);
        }

        @Override
        protected RelationshipBuilder relationshipBuilder(List<Path.Segment> list) {
            return new RelationshipBuilder((List)list);
        }

        @Override
        protected TenantBuilder tenantBuilder(List<Path.Segment> list) {
            return new TenantBuilder((List)list);
        }
    }
}

