/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.paths;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.paths.DataRole;
import org.hawkular.inventory.paths.Path;
import org.hawkular.inventory.paths.SegmentType;

public final class RelativePath
extends Path
implements Serializable {
    static final Map<String, Class<?>> SHORT_NAME_TYPES = new HashMap();
    private static final Map<SegmentType, EnumSet<SegmentType>> VALID_PROGRESSIONS = new HashMap<SegmentType, EnumSet<SegmentType>>();

    RelativePath(int start, int end, List<Path.Segment> segments) {
        super(start, end, segments);
    }

    public static RelativePath fromString(String path) {
        return RelativePath.fromPartiallyUntypedString(path, new Path.StructuredDataHintingTypeProvider());
    }

    public static RelativePath fromPartiallyUntypedString(String path, Path.TypeProvider typeProvider) {
        return (RelativePath)Path.fromString(path, false, Extender::new, new RelativeTypeProvider(typeProvider));
    }

    public static RelativePath fromPartiallyUntypedString(String path, CanonicalPath initialPosition, SegmentType intendedFinalType) {
        return (RelativePath)Path.fromString(path, false, Extender::new, new RelativeTypeProvider(new Path.HintedTypeProvider(intendedFinalType, new Extender(0, new ArrayList<Path.Segment>(initialPosition.getPath())))));
    }

    public static Extender empty() {
        return new Extender(0, new ArrayList<Path.Segment>());
    }

    public static Builder to() {
        return new Builder((List)new ArrayList());
    }

    @Override
    protected Path newInstance(int startIdx, int endIdx, List<Path.Segment> segments) {
        return new RelativePath(startIdx, endIdx, segments);
    }

    public CanonicalPath applyTo(CanonicalPath path) {
        return this.toCanonicalPath(new ArrayList<Path.Segment>(path.getPath()));
    }

    @Override
    public CanonicalPath toCanonicalPath() {
        return this.toCanonicalPath(new ArrayList<Path.Segment>());
    }

    @Override
    public RelativePath toRelativePath() {
        return this;
    }

    private CanonicalPath toCanonicalPath(List<Path.Segment> startSegments) {
        CanonicalPath.Extender extender = new CanonicalPath.Extender(0, startSegments){

            @Override
            public CanonicalPath.Extender extend(Path.Segment segment) {
                if (SegmentType.up.equals((Object)segment.getElementType())) {
                    this.removeLastSegment();
                } else {
                    super.extend(segment);
                }
                return this;
            }
        };
        this.getPath().forEach(extender::extend);
        return extender.get();
    }

    @Override
    public Extender modified() {
        return new Extender(this.startIdx, new ArrayList<Path.Segment>(this.path.subList(0, this.endIdx)));
    }

    public Iterator<RelativePath> ascendingIterator() {
        return super.ascendingIterator();
    }

    public Iterator<RelativePath> descendingIterator() {
        return super.descendingIterator();
    }

    @Override
    public RelativePath down() {
        return (RelativePath)super.down();
    }

    @Override
    public RelativePath down(int distance) {
        return (RelativePath)super.down(distance);
    }

    @Override
    public RelativePath up() {
        return (RelativePath)super.up();
    }

    @Override
    public RelativePath up(int distance) {
        return (RelativePath)super.up(distance);
    }

    public RelativePath slide(int startDelta, int endDelta) {
        return new RelativePath(this.startIdx + startDelta, this.endIdx + endDelta, this.path);
    }

    public boolean isParentOf(RelativePath other) {
        return super.isParentOf(other);
    }

    @Override
    public String toString() {
        return new Path.Encoder(s -> !SegmentType.up.equals((Object)s.getElementType())).encode("", this);
    }

    static {
        for (SegmentType c : SegmentType.values()) {
            EnumSet<Object> progressions = CanonicalPath.VALID_PROGRESSIONS.get((Object)c);
            progressions = progressions == null ? EnumSet.of(SegmentType.up) : EnumSet.of(SegmentType.up, (Enum[])progressions.toArray(new SegmentType[progressions.size()]));
            VALID_PROGRESSIONS.put(c, progressions);
        }
    }

    private static class RelativeTypeProvider
    extends Path.EnhancedTypeProvider {
        private final Path.TypeProvider wrapped;

        private RelativeTypeProvider(Path.TypeProvider wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public void segmentParsed(Path.Segment segment) {
            if (this.wrapped != null) {
                this.wrapped.segmentParsed(segment);
            }
        }

        @Override
        public Path.Segment deduceSegment(String type, String id, boolean isLast) {
            if (type != null && !type.isEmpty()) {
                SegmentType cls = SegmentType.fastValueOf(type);
                if (!SegmentType.up.equals((Object)cls) && (id == null || id.isEmpty())) {
                    return null;
                }
                if (id == null || id.isEmpty()) {
                    return new Path.Segment(cls, null);
                }
                if (SegmentType.up.equals((Object)cls)) {
                    throw new IllegalArgumentException("The \"up\" path segment cannot have an id.");
                }
                return new Path.Segment(cls, id);
            }
            if (id == null || id.isEmpty()) {
                return null;
            }
            SegmentType cls = SegmentType.fastValueOf(id);
            if (cls == null && this.wrapped != null) {
                return this.wrapped.deduceSegment(type, id, isLast);
            }
            if (SegmentType.up.equals((Object)cls)) {
                return new Path.Segment(cls, null);
            }
            return null;
        }

        @Override
        public void finished() {
            if (this.wrapped != null) {
                this.wrapped.finished();
            }
        }

        @Override
        Set<String> getValidTypeName() {
            return SHORT_NAME_TYPES.keySet();
        }
    }

    public static class Extender
    extends Path.Extender {
        Extender(int from, List<Path.Segment> segments) {
            this(from, segments, segs -> {
                if (segs.isEmpty()) {
                    return SegmentType.getRelativeShortNames();
                }
                SegmentType lastType = ((Path.Segment)segs.get(segs.size() - 1)).getElementType();
                int idx = segs.size() - 2;
                int jump = 1;
                while (SegmentType.up.equals((Object)lastType)) {
                    while (idx >= 0 && SegmentType.up.equals((Object)((Path.Segment)segs.get(idx)).getElementType())) {
                        --idx;
                        ++jump;
                    }
                    if ((idx -= jump) < 0) {
                        return SegmentType.getRelativeShortNames();
                    }
                    if (idx < 0) continue;
                    lastType = ((Path.Segment)segs.get(idx)).getElementType();
                }
                return (Collection)VALID_PROGRESSIONS.get((Object)lastType);
            });
        }

        Extender(int from, List<Path.Segment> segments, Function<List<Path.Segment>, Collection<SegmentType>> validProgressions) {
            super(from, segments, false, validProgressions);
        }

        @Override
        protected RelativePath newPath(int startIdx, int endIdx, List<Path.Segment> segments) {
            return new RelativePath(startIdx, endIdx, segments);
        }

        @Override
        public Extender extend(Path.Segment segment) {
            return (Extender)super.extend(segment);
        }

        @Override
        public Extender extend(Collection<Path.Segment> segments) {
            return (Extender)super.extend(segments);
        }

        @Override
        public Extender extend(SegmentType type, String id) {
            return (Extender)super.extend(type, id);
        }

        public Extender extendUp() {
            return (Extender)super.extend(new Path.Segment(SegmentType.up, null));
        }

        @Override
        public RelativePath get() {
            return (RelativePath)super.get();
        }
    }

    public static class UpBuilder
    extends Path.AbstractBuilder<RelativePath> {
        UpBuilder(List<Path.Segment> segments) {
            super(segments, RelativePath::new);
        }

        public TenantBuilder tenant(String id) {
            this.segments.add(new Path.Segment(SegmentType.t, id));
            return new TenantBuilder(this.segments);
        }

        public EnvironmentBuilder environment(String id) {
            this.segments.add(new Path.Segment(SegmentType.e, id));
            return new EnvironmentBuilder(this.segments);
        }

        public ResourceTypeBuilder resourceType(String id) {
            this.segments.add(new Path.Segment(SegmentType.rt, id));
            return new ResourceTypeBuilder(this.segments);
        }

        public MetricTypeBuilder metricType(String id) {
            this.segments.add(new Path.Segment(SegmentType.mt, id));
            return new MetricTypeBuilder(this.segments);
        }

        public FeedBuilder feed(String id) {
            this.segments.add(new Path.Segment(SegmentType.f, id));
            return new FeedBuilder(this.segments);
        }

        public ResourceBuilder resource(String id) {
            this.segments.add(new Path.Segment(SegmentType.r, id));
            return new ResourceBuilder(this.segments);
        }

        public MetricBuilder metric(String id) {
            this.segments.add(new Path.Segment(SegmentType.m, id));
            return new MetricBuilder(this.segments);
        }

        public StructuredDataBuilder dataEntity(String role) {
            this.segments.add(new Path.Segment(SegmentType.d, role));
            return new StructuredDataBuilder(this.segments);
        }

        public OperationTypeBuilder operationType(String id) {
            this.segments.add(new Path.Segment(SegmentType.ot, id));
            return new OperationTypeBuilder(this.segments);
        }

        public StructuredDataBuilder structuredData() {
            return new StructuredDataBuilder(this.segments);
        }

        public UpBuilder up() {
            this.segments.add(new Path.Segment(SegmentType.up, null));
            return this;
        }

        @Override
        public RelativePath get() {
            return (RelativePath)super.get();
        }
    }

    public static final class MetadataPackBuilder
    extends Path.MetadataPackBuilder<RelativePath> {
        private MetadataPackBuilder(List<Path.Segment> segments) {
            super(segments, RelativePath::new);
        }
    }

    public static final class StructuredDataBuilder
    extends Path.StructuredDataBuilder<RelativePath, StructuredDataBuilder> {
        private StructuredDataBuilder(List<Path.Segment> segments) {
            super(segments, RelativePath::new);
        }

        public UpBuilder up() {
            this.segments.add(new Path.Segment(SegmentType.up, null));
            return new UpBuilder(this.segments);
        }
    }

    public static final class RelationshipBuilder
    extends Path.RelationshipBuilder<RelativePath> {
        private RelationshipBuilder(List<Path.Segment> segments) {
            super(segments, RelativePath::new);
        }
    }

    public static final class FeedBuilder
    extends Path.FeedBuilder<RelativePath, ResourceTypeBuilder, MetricTypeBuilder, ResourceBuilder, MetricBuilder, OperationTypeBuilder, StructuredDataBuilder> {
        private FeedBuilder(List<Path.Segment> list) {
            super(list, RelativePath::new);
        }

        @Override
        protected ResourceTypeBuilder resourceTypeBuilder(List<Path.Segment> segments) {
            return new ResourceTypeBuilder((List)segments);
        }

        @Override
        protected MetricTypeBuilder metricTypeBuilder(List<Path.Segment> segments) {
            return new MetricTypeBuilder((List)segments);
        }

        @Override
        protected ResourceBuilder resourceBuilder(List<Path.Segment> segments) {
            return new ResourceBuilder((List)segments);
        }

        @Override
        protected MetricBuilder metricBuilder(List<Path.Segment> segments) {
            return new MetricBuilder((List)segments);
        }

        public UpBuilder up() {
            this.segments.add(new Path.Segment(SegmentType.up, null));
            return new UpBuilder(this.segments);
        }
    }

    public static final class MetricBuilder
    extends Path.MetricBuilder<RelativePath> {
        private MetricBuilder(List<Path.Segment> segments) {
            super(segments, RelativePath::new);
        }

        public UpBuilder up() {
            this.segments.add(new Path.Segment(SegmentType.up, null));
            return new UpBuilder(this.segments);
        }
    }

    public static final class ResourceBuilder
    extends Path.ResourceBuilder<RelativePath, ResourceBuilder, MetricBuilder, StructuredDataBuilder> {
        private ResourceBuilder(List<Path.Segment> segments) {
            super(segments, RelativePath::new);
        }

        @Override
        protected MetricBuilder metricBuilder(List<Path.Segment> segments) {
            return new MetricBuilder((List)segments);
        }

        @Override
        protected StructuredDataBuilder structuredDataBuilder(List<Path.Segment> segments) {
            return new StructuredDataBuilder((List)segments);
        }

        public UpBuilder up() {
            this.segments.add(new Path.Segment(SegmentType.up, null));
            return new UpBuilder(this.segments);
        }
    }

    public static final class OperationTypeBuilder
    extends Path.OperationTypeBuilder<RelativePath, StructuredDataBuilder> {
        private OperationTypeBuilder(List<Path.Segment> segments) {
            super(segments, RelativePath::new);
        }

        @Override
        protected StructuredDataBuilder structuredDataBuilder(List<Path.Segment> segments) {
            return new StructuredDataBuilder((List)segments);
        }

        public UpBuilder up() {
            this.segments.add(new Path.Segment(SegmentType.up, null));
            return new UpBuilder(this.segments);
        }
    }

    public static final class MetricTypeBuilder
    extends Path.MetricTypeBuilder<RelativePath> {
        private MetricTypeBuilder(List<Path.Segment> segments) {
            super(segments, RelativePath::new);
        }

        public UpBuilder up() {
            this.segments.add(new Path.Segment(SegmentType.up, null));
            return new UpBuilder(this.segments);
        }
    }

    public static final class ResourceTypeBuilder
    extends Path.ResourceTypeBuilder<RelativePath, OperationTypeBuilder, StructuredDataBuilder> {
        private ResourceTypeBuilder(List<Path.Segment> list) {
            super(list, RelativePath::new);
        }

        @Override
        protected OperationTypeBuilder operationTypeBuilder(List<Path.Segment> segments) {
            return new OperationTypeBuilder((List)segments);
        }

        @Override
        protected StructuredDataBuilder structuredDataBuilder(List<Path.Segment> segments) {
            return new StructuredDataBuilder((List)segments);
        }

        public UpBuilder up() {
            this.segments.add(new Path.Segment(SegmentType.up, null));
            return new UpBuilder(this.segments);
        }
    }

    public static final class EnvironmentBuilder
    extends Path.EnvironmentBuilder<RelativePath, ResourceBuilder, MetricBuilder, ResourceTypeBuilder, MetricTypeBuilder, OperationTypeBuilder, StructuredDataBuilder> {
        private EnvironmentBuilder(List<Path.Segment> list) {
            super(list, RelativePath::new);
        }

        @Override
        protected ResourceBuilder resourceBuilder(List<Path.Segment> segments) {
            return new ResourceBuilder((List)segments);
        }

        @Override
        protected MetricBuilder metricBuilder(List<Path.Segment> segments) {
            return new MetricBuilder((List)segments);
        }

        public UpBuilder up() {
            this.segments.add(new Path.Segment(SegmentType.up, null));
            return new UpBuilder(this.segments);
        }
    }

    public static final class TenantBuilder
    extends Path.TenantBuilder<RelativePath, EnvironmentBuilder, ResourceTypeBuilder, MetricTypeBuilder, OperationTypeBuilder, StructuredDataBuilder, MetadataPackBuilder, FeedBuilder, ResourceBuilder, MetricBuilder> {
        private TenantBuilder(List<Path.Segment> list) {
            super(list, RelativePath::new);
        }

        @Override
        protected EnvironmentBuilder environmentBuilder(List<Path.Segment> list) {
            return new EnvironmentBuilder((List)list);
        }

        @Override
        protected FeedBuilder feedBuilder(List<Path.Segment> segments) {
            return new FeedBuilder((List)segments);
        }

        @Override
        protected ResourceTypeBuilder resourceTypeBuilder(List<Path.Segment> list) {
            return new ResourceTypeBuilder((List)list);
        }

        @Override
        protected MetricTypeBuilder metricTypeBuilder(List<Path.Segment> list) {
            return new MetricTypeBuilder((List)list);
        }

        @Override
        protected MetadataPackBuilder metadataPackBuilder(List<Path.Segment> segments) {
            return new MetadataPackBuilder((List)segments);
        }

        public UpBuilder up() {
            this.segments.add(new Path.Segment(SegmentType.up, null));
            return new UpBuilder(this.segments);
        }
    }

    public static final class Builder
    extends Path.Builder<RelativePath, TenantBuilder, EnvironmentBuilder, ResourceTypeBuilder, MetricTypeBuilder, RelationshipBuilder, OperationTypeBuilder, StructuredDataBuilder, MetadataPackBuilder, FeedBuilder, ResourceBuilder, MetricBuilder> {
        private Builder(List<Path.Segment> list) {
            super(list, RelativePath::new);
        }

        @Override
        protected RelationshipBuilder relationshipBuilder(List<Path.Segment> list) {
            return new RelationshipBuilder((List)list);
        }

        @Override
        protected TenantBuilder tenantBuilder(List<Path.Segment> list) {
            return new TenantBuilder((List)list);
        }

        public EnvironmentBuilder environment(String id) {
            this.segments.add(new Path.Segment(SegmentType.e, id));
            return new EnvironmentBuilder(this.segments);
        }

        public ResourceTypeBuilder resourceType(String id) {
            this.segments.add(new Path.Segment(SegmentType.rt, id));
            return new ResourceTypeBuilder(this.segments);
        }

        public MetricTypeBuilder metricType(String id) {
            this.segments.add(new Path.Segment(SegmentType.mt, id));
            return new MetricTypeBuilder(this.segments);
        }

        public FeedBuilder feed(String id) {
            this.segments.add(new Path.Segment(SegmentType.f, id));
            return new FeedBuilder(this.segments);
        }

        public ResourceBuilder resource(String id) {
            this.segments.add(new Path.Segment(SegmentType.r, id));
            return new ResourceBuilder(this.segments);
        }

        public MetricBuilder metric(String id) {
            this.segments.add(new Path.Segment(SegmentType.m, id));
            return new MetricBuilder(this.segments);
        }

        public StructuredDataBuilder dataEntity(DataRole role) {
            this.segments.add(new Path.Segment(SegmentType.d, role.name()));
            return new StructuredDataBuilder(this.segments);
        }

        public OperationTypeBuilder operationType(String id) {
            this.segments.add(new Path.Segment(SegmentType.ot, id));
            return new OperationTypeBuilder(this.segments);
        }

        public StructuredDataBuilder structuredData() {
            return new StructuredDataBuilder(this.segments);
        }

        public MetadataPackBuilder metadataPack() {
            return new MetadataPackBuilder(this.segments);
        }

        public UpBuilder up() {
            this.segments.add(new Path.Segment(SegmentType.up, null));
            return new UpBuilder(this.segments);
        }
    }

    public static final class Up {
        public static final SegmentType SEGMENT_TYPE = SegmentType.up;

        private Up() {
        }
    }
}

