/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.paths;

import java.util.Collection;
import java.util.HashMap;

public interface DataRole {
    public static DataRole valueOf(String name) {
        return (DataRole)Resource.ImplDetail.instances.get(name);
    }

    public static DataRole[] values() {
        Collection values = Resource.ImplDetail.instances.values();
        return values.toArray(new DataRole[values.size()]);
    }

    public String name();

    public boolean isSchema();

    public static enum OperationType implements DataRole
    {
        returnType,
        parameterTypes;


        @Override
        public boolean isSchema() {
            return true;
        }
    }

    public static enum ResourceType implements DataRole
    {
        configurationSchema,
        connectionConfigurationSchema;


        @Override
        public boolean isSchema() {
            return true;
        }
    }

    public static enum Resource implements DataRole
    {
        configuration,
        connectionConfiguration;


        @Override
        public boolean isSchema() {
            return false;
        }

        private static final class ImplDetail {
            private static final HashMap<String, DataRole> instances = new HashMap();

            private ImplDetail() {
            }

            static {
                for (Resource resource : Resource.values()) {
                    instances.put(resource.name(), resource);
                }
                for (Enum enum_ : ResourceType.values()) {
                    instances.put(enum_.name(), (DataRole)((Object)enum_));
                }
                for (Enum enum_ : OperationType.values()) {
                    instances.put(enum_.name(), (DataRole)((Object)enum_));
                }
            }
        }
    }
}

