/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.nest.extension.log;

import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;

@MessageLogger(projectCode="HAWKBUS")
@ValidIdRange(min=130000, max=139999)
public interface MsgLogger {
    public static final MsgLogger LOGGER = (MsgLogger)Logger.getMessageLogger(MsgLogger.class, (String)MsgLogger.class.getPackage().getName());

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=130000, value="Nest service starting")
    public void infoNestStarting();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=130001, value="Nest service started")
    public void infoNestStarted();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=130002, value="Nest service stopping")
    public void infoNestStopping();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=130003, value="Nest service stopped")
    public void infoNestStopped();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=130004, value="Nest name=[%s]")
    public void infoNestName(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=130005, value="Broker service is not started")
    public void infoBrokerServiceNotStarted();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=130006, value="Cannot close the messaging connection context factory")
    public void errorCannotCloseMsgConnCtxFactory(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=130007, value="There is a broker at [%s]")
    public void infoBrokerExists(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=130008, value="[%d] deployments found")
    public void infoDeploymentsFound(int var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=130009, value="%d. Deploying [%s]")
    public void infoDeploying(int var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=130010, value="Failed to get deployments from [%s] - nothing will be deployed")
    public void errorFailedGettingDeployments(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=130011, value="[%s] is not a directory - nothing will be deployed")
    public void errorBadDeploymentsDirectory(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=130012, value="Missing directory [%s] - nothing will be deployed")
    public void errorMissingDeploymentsDirectory(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=130013, value="Nest is not enabled and will not be deployed")
    public void infoNestNotEnabled();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=130014, value="Nest is enabled and will be deployed")
    public void infoNestEnabled();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=130015, value="Initializing Nest subsystem")
    public void infoInitializingNestSubsystem();
}

