/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.nest.extension;

import java.util.Map;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.common.beans.property.PropertiesValueResolver;
import org.jboss.logging.Logger;

public class NestConfigurationSetup {
    private final Logger log = Logger.getLogger(NestConfigurationSetup.class);
    private final Map<String, String> customConfiguration;
    private final ServerEnvironment serverEnvironment;

    public NestConfigurationSetup(Map<String, String> customConfigProps, ServerEnvironment serverEnv) {
        this.customConfiguration = customConfigProps;
        this.serverEnvironment = serverEnv;
        this.prepareConfiguration();
    }

    public Map<String, String> getCustomConfiguration() {
        return this.customConfiguration;
    }

    public ServerEnvironment getServerEnvironment() {
        return this.serverEnvironment;
    }

    private void prepareConfiguration() {
        for (Map.Entry<String, String> entry : this.customConfiguration.entrySet()) {
            String value = entry.getValue();
            if (value == null) continue;
            entry.setValue(PropertiesValueResolver.replaceProperties((String)value));
        }
        this.log.debugf("configuration: [%s]", this.customConfiguration);
    }
}

