/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.nest.extension;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hawkular.nest.extension.log.MsgLogger;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class NestService
implements Service<NestService> {
    public static final ServiceName SERVICE_NAME = ServiceName.of((String[])new String[]{"org.hawkular.nest"}).append(new String[]{"hawkular-nest"});
    private final MsgLogger msglog = MsgLogger.LOGGER;
    private final Logger log = Logger.getLogger(NestService.class);
    final InjectedValue<ServerEnvironment> envServiceValue = new InjectedValue();
    private Map<String, String> customConfigProperties = Collections.synchronizedMap(new HashMap());
    private boolean started = false;
    private String nestName;

    public NestService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public void start(StartContext context) throws StartException {
        this.msglog.infoNestStarting();
        this.startNest();
        this.msglog.infoNestStarted();
    }

    public void stop(StopContext context) {
        this.msglog.infoNestStopping();
        this.stopNest();
        this.msglog.infoNestStopped();
    }

    public boolean isStarted() {
        return this.started;
    }

    protected void startNest() throws StartException {
        if (this.isStarted()) {
            return;
        }
        this.msglog.infoNestName(this.getNestName());
        this.started = true;
    }

    protected void stopNest() {
        if (!this.isStarted()) {
            return;
        }
        this.started = false;
    }

    protected void setNestName(String name) {
        this.nestName = name;
    }

    protected String getNestName() {
        if (this.nestName == null || this.nestName.equals("autogenerate")) {
            return ((ServerEnvironment)this.envServiceValue.getValue()).getNodeName();
        }
        return this.nestName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCustomConfigurationProperties(Map<String, String> properties) {
        Map<String, String> map = this.customConfigProperties;
        synchronized (map) {
            this.customConfigProperties.clear();
            if (properties != null) {
                this.customConfigProperties.putAll(properties);
            }
        }
    }
}

