/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.nest.extension;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import org.hawkular.nest.extension.NestService;
import org.hawkular.nest.extension.NestSubsystemDefinition;
import org.hawkular.nest.extension.log.MsgLogger;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;

class NestSubsystemAdd
extends AbstractAddStepHandler {
    static final NestSubsystemAdd INSTANCE = new NestSubsystemAdd();
    private final MsgLogger msglog = MsgLogger.LOGGER;
    private final Logger log = Logger.getLogger(NestSubsystemAdd.class);

    private NestSubsystemAdd() {
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        try {
            if (this.requiresRuntime(context)) {
                URL deploymentsUrl = null;
                Module module = Module.forClass(((Object)((Object)this)).getClass());
                deploymentsUrl = module != null ? module.getExportedResource("deployments") : ((Object)((Object)this)).getClass().getClassLoader().getResource("deployments");
                if (deploymentsUrl != null) {
                    File deploymentsDir = new File(deploymentsUrl.toURI());
                    if (deploymentsDir.isDirectory()) {
                        File[] deployments = deploymentsDir.listFiles(new FilenameFilter(){

                            @Override
                            public boolean accept(File dir, String name) {
                                return name.endsWith(".ear") || name.endsWith(".war") || name.endsWith(".jar");
                            }
                        });
                        if (deployments != null) {
                            this.msglog.infoDeploymentsFound(deployments.length);
                            int deploymentNumber = 1;
                            for (File deployment : deployments) {
                                PathAddress deploymentAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"deployment", (String)deployment.getName())});
                                ModelNode op = Util.getEmptyOperation((String)"add", (ModelNode)deploymentAddress.toModelNode());
                                op.get("enabled").set(true);
                                op.get("persistent").set(false);
                                ModelNode contentItem = new ModelNode();
                                if (deployment.isDirectory()) {
                                    contentItem.get("path").set(deployment.getAbsolutePath());
                                    contentItem.get("archive").set(false);
                                } else {
                                    contentItem.get("url").set(deployment.toURI().toURL().toExternalForm());
                                }
                                op.get("content").add(contentItem);
                                ImmutableManagementResourceRegistration rootResourceRegistration = context.getRootResourceRegistration();
                                OperationStepHandler handler = rootResourceRegistration.getOperationHandler(deploymentAddress, "add");
                                context.addStep(op, handler, OperationContext.Stage.MODEL);
                                this.msglog.infoDeploying(deploymentNumber++, deployment.getName());
                            }
                        } else {
                            this.msglog.errorFailedGettingDeployments("deployments");
                        }
                    } else {
                        this.msglog.errorBadDeploymentsDirectory("deployments");
                    }
                } else {
                    this.msglog.errorMissingDeploymentsDirectory("deployments");
                }
            }
        }
        catch (Exception e) {
            throw new OperationFailedException("Deployments failed", (Throwable)e);
        }
        this.populateModel(operation, resource.getModel());
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        NestSubsystemDefinition.NEST_ENABLED_ATTRIBDEF.validateAndSet(operation, model);
        NestSubsystemDefinition.NEST_NAME_ATTRIBDEF.validateAndSet(operation, model);
        NestSubsystemDefinition.CUSTOM_CONFIG_ATTRIBDEF.validateAndSet(operation, model);
        this.log.debugf("Populating the Nest subsystem model: %s=%s", (Object)operation, (Object)model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        boolean enabled = NestSubsystemDefinition.NEST_ENABLED_ATTRIBDEF.resolveModelAttribute(context, model).asBoolean(false);
        if (!enabled) {
            this.msglog.infoNestNotEnabled();
            return;
        }
        this.msglog.infoNestEnabled();
        ModelNode node = NestSubsystemDefinition.NEST_NAME_ATTRIBDEF.resolveModelAttribute(context, model);
        String nestName = "autogenerate";
        if (node.isDefined()) {
            nestName = node.asString();
        }
        HashMap<String, String> customConfigProps = new HashMap<String, String>();
        ModelNode customConfigNode = NestSubsystemDefinition.CUSTOM_CONFIG_ATTRIBDEF.resolveModelAttribute(context, model);
        if (customConfigNode != null && customConfigNode.isDefined()) {
            HashMap<String, String> customConfig = new HashMap<String, String>();
            List propList = customConfigNode.asPropertyList();
            for (Property prop : propList) {
                String name = prop.getName();
                String val = prop.getValue().asString();
                customConfig.put(name, val);
            }
            customConfigProps.putAll(customConfig);
        }
        NestService service = new NestService();
        service.setNestName(nestName);
        service.setCustomConfigurationProperties(customConfigProps);
        ServiceName name = NestService.SERVICE_NAME;
        ServiceController controller = context.getServiceTarget().addService(name, (Service)service).addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, service.envServiceValue).addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.ACTIVE).install();
        newControllers.add(controller);
    }
}

