/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.commons.rest.status;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.servlet.ServletContext;

class ManifestUtil {
    static final String IMPLEMENTATION_VERSION = "Implementation-Version";
    static final String BUILT_FROM_GIT = "Built-From-Git-SHA1";
    private static final String[] VERSION_ATTRIBUTES = new String[]{"Implementation-Version", "Built-From-Git-SHA1"};
    static final String UNKNOWN_VALUE = "Unknown";

    ManifestUtil() {
    }

    public static Map<String, String> getVersionAttributes(ServletContext servletContext) throws IOException {
        URL url = servletContext.getResource("/META-INF/MANIFEST.MF");
        if (url != null) {
            return ManifestUtil.getVersionAttributes(url);
        }
        return new LinkedHashMap<String, String>();
    }

    static Map<String, String> getVersionAttributes(URL url) throws IOException {
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        try (InputStream inputStream = url.openStream();){
            Manifest manifest = new Manifest(inputStream);
            Attributes attributes = manifest.getMainAttributes();
            String[] stringArray = VERSION_ATTRIBUTES;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String key;
                String value = attributes.getValue(key = stringArray[i]);
                ret.put(key, value == null ? UNKNOWN_VALUE : value);
            }
        }
        return ret;
    }
}

