/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.component.pinger;

import java.util.Arrays;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.Asynchronous;
import javax.ejb.Singleton;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSContext;
import javax.jms.JMSProducer;
import javax.jms.Queue;
import org.hawkular.component.pinger.Log;
import org.hawkular.component.pinger.MetricDataMessage;
import org.hawkular.component.pinger.PingStatus;

@Singleton
public class MetricPublisher {
    @Resource(mappedName="java:/queue/hawkular/metrics/gauges/new")
    Queue gaugesQueue;
    @Resource(mappedName="java:/HawkularBusConnectionFactory")
    private ConnectionFactory connectionFactory;
    private JMSContext context;
    private JMSProducer producer;

    @PostConstruct
    public void createContext() {
        this.context = this.connectionFactory.createContext();
        this.producer = this.context.createProducer();
    }

    @Asynchronous
    public void publish(PingStatus status) {
        String resourceId = status.getDestination().getResourceId();
        long timestamp = status.getTimestamp();
        MetricDataMessage message = new MetricDataMessage();
        MetricDataMessage.MetricData metricData = new MetricDataMessage.MetricData();
        MetricDataMessage.SingleMetric durationMetric = new MetricDataMessage.SingleMetric(resourceId + ".status.duration", timestamp, (double)status.getDuration());
        MetricDataMessage.SingleMetric statusCodeMetric = new MetricDataMessage.SingleMetric(resourceId + ".status.code", timestamp, (double)status.getCode());
        metricData.setTenantId(status.getDestination().getTenantId());
        metricData.setData(Arrays.asList(durationMetric, statusCodeMetric));
        message.setMetricData(metricData);
        try {
            this.producer.send((Destination)this.gaugesQueue, message.toJSON());
        }
        catch (Exception e) {
            Log.LOG.eCouldNotSendMessage((Throwable)e);
        }
    }

    @PreDestroy
    public void closeContext() {
        if (this.context != null) {
            try {
                this.context.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

