/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.component.pinger;

import org.hawkular.component.pinger.PingDestination;
import org.hawkular.component.pinger.Traits;

public class PingStatus {
    public static final int INVALID_DURATION = -1;
    private final PingDestination destination;
    private final int duration;
    private final int code;
    private final boolean timedOut;
    private final long timestamp;
    private final Traits traits;

    public static final PingStatus timeout(PingDestination destination, long timestamp, int duration) {
        return new PingStatus(destination, 503, timestamp, duration, true, Traits.empty((long)timestamp));
    }

    public static final PingStatus error(PingDestination destination, int code, long timestamp) {
        return new PingStatus(destination, code, timestamp, -1, Traits.empty((long)timestamp));
    }

    public PingStatus(PingDestination destination, int code, long timestamp, int duration, Traits traits) {
        this(destination, code, timestamp, duration, false, traits);
    }

    private PingStatus(PingDestination destination, int code, long timestamp, int duration, boolean timedOut, Traits traits) {
        this.destination = destination;
        this.code = code;
        this.timestamp = timestamp;
        this.duration = duration;
        this.timedOut = timedOut;
        this.traits = traits;
    }

    public int getCode() {
        return this.code;
    }

    public int getDuration() {
        return this.duration;
    }

    public boolean isTimedOut() {
        return this.timedOut;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public PingDestination getDestination() {
        return this.destination;
    }

    public Traits getTraits() {
        return this.traits;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.code;
        result = 31 * result + (this.destination == null ? 0 : this.destination.hashCode());
        result = 31 * result + this.duration;
        result = 31 * result + (this.timedOut ? 1231 : 1237);
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + (this.traits == null ? 0 : this.traits.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PingStatus other = (PingStatus)obj;
        if (this.code != other.code) {
            return false;
        }
        if (this.destination == null ? other.destination != null : !this.destination.equals((Object)other.destination)) {
            return false;
        }
        if (this.duration != other.duration) {
            return false;
        }
        if (this.timedOut != other.timedOut) {
            return false;
        }
        if (this.timestamp != other.timestamp) {
            return false;
        }
        return !(this.traits == null ? other.traits != null : !this.traits.equals((Object)other.traits));
    }

    public String toString() {
        return "PingStatus [destination=" + this.destination + ", duration=" + this.duration + ", code=" + this.code + ", timedOut=" + this.timedOut + ", timestamp=" + this.timestamp + ", traits=" + this.traits + "]";
    }
}

