/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.component.pinger;

import java.net.InetAddress;
import java.util.TreeSet;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpResponse;
import org.hawkular.component.pinger.Log;
import org.hawkular.component.pinger.Traits;

/*
 * Exception performing whole class analysis ignored.
 */
public class Traits {
    private static final String ASP_NET = "ASP.NET";
    private final String poweredBy;
    private final InetAddress remoteAddress;
    private final long timestamp;

    public static Traits collect(HttpResponse httpResponse, long timestamp, InetAddress remoteAddress) {
        TreeSet<String> xPoweredBy = null;
        StringBuilder poweredByBuilder = new StringBuilder();
        boolean hasAspNet = false;
        HeaderIterator headers = httpResponse.headerIterator();
        while (headers.hasNext()) {
            Header header = headers.nextHeader();
            Log.LOG.tracef("Is this a trait header? %s:%s from %s", (Object)header.getName(), (Object)header.getValue(), (Object)remoteAddress);
            TraitHeader traitHeader = TraitHeader.fastValueOf((String)header.getName());
            if (traitHeader == null) continue;
            Log.LOG.tracef("Found a trait header: %s:%s from %s", (Object)header.getName(), (Object)header.getValue(), (Object)remoteAddress);
            switch (1.$SwitchMap$org$hawkular$component$pinger$Traits$TraitHeader[traitHeader.ordinal()]) {
                case 1: {
                    if (poweredByBuilder.length() != 0) {
                        poweredByBuilder.append(", ");
                    }
                    poweredByBuilder.append(header.getValue());
                    break;
                }
                case 2: {
                    String powBy = header.getValue();
                    if (xPoweredBy == null) {
                        xPoweredBy = new TreeSet();
                    }
                    if ("ASP.NET".equals(powBy)) {
                        if (!hasAspNet) {
                            xPoweredBy.add(powBy);
                        }
                        hasAspNet = true;
                        break;
                    }
                    xPoweredBy.add(powBy);
                    break;
                }
                case 3: {
                    if (hasAspNet) {
                        xPoweredBy.remove("ASP.NET");
                    }
                    if (xPoweredBy == null) {
                        xPoweredBy = new TreeSet<String>();
                    }
                    xPoweredBy.add("ASP.NET/" + header.getValue());
                    hasAspNet = true;
                    break;
                }
            }
        }
        if (xPoweredBy != null) {
            for (String val : xPoweredBy) {
                if (poweredByBuilder.length() != 0) {
                    poweredByBuilder.append(", ");
                }
                poweredByBuilder.append(val);
            }
        }
        return new Traits(timestamp, remoteAddress, poweredByBuilder.length() == 0 ? null : poweredByBuilder.toString());
    }

    public static Traits empty(long timestamp) {
        return new Traits(timestamp, null, null);
    }

    Traits(long timestamp, InetAddress remoteAddress, String poweredBy) {
        this.timestamp = timestamp;
        this.remoteAddress = remoteAddress;
        this.poweredBy = poweredBy;
    }

    public String getPoweredBy() {
        return this.poweredBy;
    }

    public InetAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Traits other = (Traits)obj;
        if (this.timestamp != other.timestamp) {
            return false;
        }
        if (this.remoteAddress == null ? other.remoteAddress != null : !this.remoteAddress.equals(other.remoteAddress)) {
            return false;
        }
        return !(this.poweredBy == null ? other.poweredBy != null : !this.poweredBy.equals(other.poweredBy));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.poweredBy == null ? 0 : this.poweredBy.hashCode());
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + (this.remoteAddress == null ? 0 : this.remoteAddress.hashCode());
        return result;
    }

    public String toString() {
        return "Traits [poweredBy=" + this.poweredBy + ", timestamp=" + this.timestamp + ", remoteAddress=" + this.remoteAddress + "]";
    }
}

