/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.component.wildflymonitor;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.util.Base64;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.annotation.security.PermitAll;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@PermitAll
@WebServlet(urlPatterns={"/download", "/installer"}, loadOnStartup=1)
public class WildFlyAgentServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String SYSPROP_AGENT_DOWNLOADS_LIMIT = "hawkular.wildfly.agent.downloads.limit";
    private static final int DEFAULT_AGENT_DOWNLOADS_LIMIT = 100;
    private static final String AGENT_INSTALLER_PROPERTIES_FILE_NAME = "hawkular-wildfly-agent-installer.properties";
    static final String AGENT_INSTALLER_ENCRYPTION_KEY = "encryption-key";
    static final String AGENT_INSTALLER_ENCRYPTION_SALT = "encryption-salt";
    static final String AGENT_INSTALLER_ENCRYPTION_WEAK = "encryption-weak";
    private static final String AGENT_INSTALLER_PROPERTY_ENABLED = "enabled";
    private static final String AGENT_INSTALLER_PROPERTY_TARGET_LOCATION = "target-location";
    private static final String AGENT_INSTALLER_PROPERTY_MODULE_DIST = "module-dist";
    private static final String AGENT_INSTALLER_PROPERTY_SERVER_URL = "server-url";
    private static final String AGENT_INSTALLER_PROPERTY_MANAGED_SERVER_NAME = "managed-server-name";
    private static final String AGENT_INSTALLER_PROPERTY_USERNAME = "username";
    private static final String AGENT_INSTALLER_PROPERTY_PASSWORD = "password";
    private static final String AGENT_INSTALLER_PROPERTY_SECURITY_KEY = "security-key";
    private static final String AGENT_INSTALLER_PROPERTY_SECURITY_SECRET = "security-secret";
    private static final String AGENT_INSTALLER_PROPERTY_KEYSTORE_PATH = "keystore-path";
    private static final String AGENT_INSTALLER_PROPERTY_KEYSTORE_PASSWORD = "keystore-password";
    private static final String AGENT_INSTALLER_PROPERTY_KEY_PASSWORD = "key-password";
    private static final String AGENT_INSTALLER_PROPERTY_KEY_ALIAS = "key-alias";
    private static final int ERROR_CODE_AGENT_UPDATE_DISABLED = 403;
    private static final int ERROR_CODE_TOO_MANY_DOWNLOADS = 503;
    private static AtomicInteger numActiveDownloads = null;
    private File moduleDownloadFile = null;
    private File installerDownloadFile = null;

    public void init() throws ServletException {
        this.log("Starting the WildFly Agent download servlet");
        numActiveDownloads = new AtomicInteger(0);
        try {
            this.log("Agent Module File: " + this.getAgentModuleDownloadFile());
        }
        catch (Throwable t) {
            throw new ServletException("Missing Hawkular WildFly Agent module download file", t);
        }
        try {
            this.log("Agent Installer File: " + this.getAgentInstallerDownloadFile());
        }
        catch (Throwable t) {
            throw new ServletException("Missing Hawkular WildFly Agent installer download file", t);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doIt(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doIt(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doIt(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.disableBrowserCache(resp);
        String servletPath = req.getServletPath();
        if (servletPath != null) {
            if (servletPath.endsWith("download") || servletPath.endsWith("installer")) {
                try {
                    numActiveDownloads.incrementAndGet();
                    this.getDownload(req, resp);
                }
                finally {
                    numActiveDownloads.decrementAndGet();
                }
            } else {
                resp.sendError(400, "Invalid servlet path [" + servletPath + "] - please contact administrator");
            }
        } else {
            resp.sendError(400, "Invalid servlet path - please contact administrator");
        }
    }

    private void downloadAgentModule(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            File agentModuleZip = this.getAgentModuleDownloadFile();
            resp.setContentType("application/octet-stream");
            resp.setHeader("Content-Disposition", "attachment; filename=" + agentModuleZip.getName());
            resp.setContentLength((int)agentModuleZip.length());
            resp.setDateHeader("Last-Modified", agentModuleZip.lastModified());
            try (FileInputStream agentModuleZipStream = new FileInputStream(agentModuleZip);){
                this.copy((InputStream)agentModuleZipStream, (OutputStream)resp.getOutputStream());
            }
        }
        catch (Throwable t) {
            String clientAddr = this.getClientAddress(req);
            this.log("Failed to stream file to remote client [" + clientAddr + "]", t);
            this.disableBrowserCache(resp);
            resp.sendError(500, "Failed to stream file");
        }
    }

    private void downloadAgentInstaller(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            File agentInstallerJar = this.getAgentInstallerDownloadFile();
            resp.setContentType("application/octet-stream");
            resp.setHeader("Content-Disposition", "attachment; filename=" + agentInstallerJar.getName());
            resp.setDateHeader("Last-Modified", agentInstallerJar.lastModified());
            HashMap<String, String> newProperties = new HashMap<String, String>();
            String serverUrl = this.getValueFromRequestParam(req, AGENT_INSTALLER_PROPERTY_SERVER_URL, null);
            if (serverUrl == null) {
                serverUrl = this.getDefaultHawkularServerUrl(req);
            }
            if (serverUrl.endsWith("/")) {
                serverUrl = serverUrl.substring(0, serverUrl.length() - 1);
            }
            new URL(serverUrl);
            newProperties.put(AGENT_INSTALLER_PROPERTY_SERVER_URL, serverUrl);
            newProperties.put(AGENT_INSTALLER_PROPERTY_MANAGED_SERVER_NAME, this.getValueFromRequestParam(req, AGENT_INSTALLER_PROPERTY_MANAGED_SERVER_NAME, null));
            newProperties.put(AGENT_INSTALLER_PROPERTY_MODULE_DIST, this.getValueFromRequestParam(req, AGENT_INSTALLER_PROPERTY_MODULE_DIST, serverUrl + "/hawkular/wildfly-agent/download"));
            newProperties.put(AGENT_INSTALLER_PROPERTY_TARGET_LOCATION, this.getValueFromRequestParam(req, AGENT_INSTALLER_PROPERTY_TARGET_LOCATION, null));
            newProperties.put(AGENT_INSTALLER_PROPERTY_ENABLED, this.getValueFromRequestParam(req, AGENT_INSTALLER_PROPERTY_ENABLED, null));
            newProperties.put(AGENT_INSTALLER_PROPERTY_USERNAME, this.getValueFromRequestParam(req, AGENT_INSTALLER_PROPERTY_USERNAME, null));
            newProperties.put(AGENT_INSTALLER_PROPERTY_PASSWORD, this.getValueFromRequestParam(req, AGENT_INSTALLER_PROPERTY_PASSWORD, null));
            newProperties.put(AGENT_INSTALLER_PROPERTY_SECURITY_KEY, this.getValueFromRequestParam(req, AGENT_INSTALLER_PROPERTY_SECURITY_KEY, null));
            newProperties.put(AGENT_INSTALLER_PROPERTY_SECURITY_SECRET, this.getValueFromRequestParam(req, AGENT_INSTALLER_PROPERTY_SECURITY_SECRET, null));
            newProperties.put(AGENT_INSTALLER_PROPERTY_KEYSTORE_PATH, this.getValueFromRequestParam(req, AGENT_INSTALLER_PROPERTY_KEYSTORE_PATH, null));
            newProperties.put(AGENT_INSTALLER_PROPERTY_KEY_ALIAS, this.getValueFromRequestParam(req, AGENT_INSTALLER_PROPERTY_KEY_ALIAS, null));
            newProperties.put(AGENT_INSTALLER_PROPERTY_KEYSTORE_PASSWORD, this.getValueFromRequestParam(req, AGENT_INSTALLER_PROPERTY_KEYSTORE_PASSWORD, null));
            newProperties.put(AGENT_INSTALLER_PROPERTY_KEY_PASSWORD, this.getValueFromRequestParam(req, AGENT_INSTALLER_PROPERTY_KEY_PASSWORD, null));
            String encryptionKey = this.getValueFromRequestParam(req, AGENT_INSTALLER_ENCRYPTION_KEY, null);
            String encryptionSalt = this.getValueFromRequestParam(req, AGENT_INSTALLER_ENCRYPTION_SALT, null);
            String encryptionWeak = this.getValueFromRequestParam(req, AGENT_INSTALLER_ENCRYPTION_WEAK, null);
            boolean useWeakEncryption = "true".equalsIgnoreCase(encryptionWeak);
            if (encryptionKey != null) {
                if (encryptionSalt == null) {
                    encryptionSalt = encryptionKey;
                }
                this.encode(newProperties, AGENT_INSTALLER_PROPERTY_KEYSTORE_PASSWORD, encryptionKey, encryptionSalt, useWeakEncryption);
                this.encode(newProperties, AGENT_INSTALLER_PROPERTY_KEY_PASSWORD, encryptionKey, encryptionSalt, useWeakEncryption);
                this.encode(newProperties, AGENT_INSTALLER_PROPERTY_PASSWORD, encryptionKey, encryptionSalt, useWeakEncryption);
                this.encode(newProperties, AGENT_INSTALLER_PROPERTY_SECURITY_SECRET, encryptionKey, encryptionSalt, useWeakEncryption);
            }
            int contentLength = 0;
            try (ZipFile agentInstallerZip = new ZipFile(agentInstallerJar);
                 ZipOutputStream zos = new ZipOutputStream((OutputStream)resp.getOutputStream(), StandardCharsets.UTF_8);){
                Enumeration<? extends ZipEntry> e = agentInstallerZip.entries();
                while (e.hasMoreElements()) {
                    Throwable throwable;
                    ZipEntry entryIn = e.nextElement();
                    if (!entryIn.getName().equalsIgnoreCase(AGENT_INSTALLER_PROPERTIES_FILE_NAME)) {
                        zos.putNextEntry(entryIn);
                        throwable = null;
                        try (InputStream is = agentInstallerZip.getInputStream(entryIn);){
                            int len;
                            byte[] buf = new byte[4096];
                            while ((len = is.read(buf)) > 0) {
                                zos.write(buf, 0, len);
                                contentLength += len;
                            }
                        }
                        catch (Throwable buf) {
                            throwable = buf;
                            throw buf;
                        }
                    }
                    zos.putNextEntry(new ZipEntry(AGENT_INSTALLER_PROPERTIES_FILE_NAME));
                    throwable = null;
                    try (BufferedReader br = new BufferedReader(new InputStreamReader(agentInstallerZip.getInputStream(entryIn), StandardCharsets.UTF_8));){
                        String line;
                        while ((line = br.readLine()) != null) {
                            for (Map.Entry entry : newProperties.entrySet()) {
                                String newLine = this.getNewPropertyLine(line, (String)entry.getKey(), (String)entry.getValue());
                                if (line.equals(newLine)) continue;
                                line = newLine;
                                break;
                            }
                            byte[] buf = (line + '\n').getBytes(StandardCharsets.UTF_8);
                            zos.write(buf);
                            contentLength += buf.length;
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    zos.closeEntry();
                }
            }
            this.log("Sending Hawkular WildFly Agent installer with content length of: " + contentLength);
        }
        catch (Throwable t) {
            String clientAddr = this.getClientAddress(req);
            this.log("Failed to stream file to remote client [" + clientAddr + "]", t);
            this.disableBrowserCache(resp);
            resp.sendError(500, "Failed to stream file: " + t);
        }
    }

    private void encode(HashMap<String, String> properties, String propertyName, String encryptionKey, String encryptionSalt, boolean useWeakEncryption) throws Exception {
        String clearText = properties.get(propertyName);
        if (null == clearText) {
            return;
        }
        String finalPropertyValue = useWeakEncryption ? this.doEncodeWeak(clearText, encryptionKey, encryptionSalt) : this.doEncode(clearText, encryptionKey, encryptionSalt);
        properties.put(propertyName, finalPropertyValue);
    }

    private String doEncodeWeak(String clearText, String encryptionKey, String encryptionSalt) throws Exception {
        byte[] salt = encryptionSalt.getBytes("UTF-8");
        Cipher cipher = Cipher.getInstance("DES");
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        PBEKeySpec spec = new PBEKeySpec(encryptionKey.toCharArray(), salt, 80000, 64);
        SecretKeySpec keySpec = new SecretKeySpec(factory.generateSecret(spec).getEncoded(), "DES");
        cipher.init(1, keySpec);
        byte[] encryptedData = cipher.doFinal(clearText.getBytes("UTF-8"));
        return new String(Base64.getEncoder().encode(encryptedData), "UTF-8");
    }

    private String doEncode(String clearText, String encryptionKey, String encryptionSalt) throws Exception {
        byte[] salt = encryptionSalt.getBytes("UTF-8");
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        PBEKeySpec spec = new PBEKeySpec(encryptionKey.toCharArray(), salt, 80000, 256);
        SecretKeySpec keySpec = new SecretKeySpec(factory.generateSecret(spec).getEncoded(), "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
        try {
            cipher.init(1, keySpec);
        }
        catch (InvalidKeyException invalidKeyException) {
            this.log("WARNING: Server does not support strong encryption. Using weak encryption.");
            return this.doEncodeWeak(clearText, encryptionKey, encryptionSalt);
        }
        byte[] encryptedData = cipher.doFinal(clearText.getBytes("UTF-8"));
        String ivAsString = new String(Base64.getEncoder().encode(cipher.getIV()), "UTF-8");
        String encryptedAsString = new String(Base64.getEncoder().encode(encryptedData), "UTF-8");
        return ivAsString + "$" + encryptedAsString;
    }

    private String getNewPropertyLine(String lineToModify, String propNameToFind, String newPropValue) {
        Matcher m = Pattern.compile("#? *" + propNameToFind + " *=.*").matcher(lineToModify);
        if (m.matches()) {
            lineToModify = newPropValue != null ? m.replaceAll(propNameToFind + "=" + newPropValue) : m.replaceAll("#" + propNameToFind + "=");
        }
        return lineToModify;
    }

    private String getDefaultHawkularServerUrl(HttpServletRequest request) {
        try {
            URL url = new URL(request.getRequestURL().toString());
            String protocol = url.getProtocol();
            String hostname = url.getHost();
            int port = url.getPort();
            if (port > 0) {
                return String.format("%s://%s:%d", protocol, hostname, port);
            }
            return String.format("%s://%s", protocol, hostname);
        }
        catch (Exception e) {
            this.log("Cannot determine request URL; will use http://localhost:8080 as default: " + e);
            return "http://localhost:8080";
        }
    }

    private String getValueFromRequestParam(HttpServletRequest req, String key, String defaultValue) throws IOException {
        String value = req.getParameter(key);
        if (value == null || value.isEmpty()) {
            return defaultValue;
        }
        return value;
    }

    private void getDownload(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        int limit = this.getDownloadLimit();
        if (limit <= 0) {
            this.sendErrorDownloadsDisabled(resp);
            return;
        }
        if (limit < numActiveDownloads.get()) {
            this.sendErrorTooManyDownloads(resp);
            return;
        }
        if (req.getServletPath().endsWith("installer")) {
            this.downloadAgentInstaller(req, resp);
        } else {
            this.downloadAgentModule(req, resp);
        }
    }

    private int getDownloadLimit() {
        int limit;
        String limitStr = System.getProperty(SYSPROP_AGENT_DOWNLOADS_LIMIT, String.valueOf(100));
        try {
            limit = Integer.parseInt(limitStr);
        }
        catch (Exception e) {
            limit = 100;
            this.log("Agent downloads limit system property [hawkular.wildfly.agent.downloads.limit] is invalid [" + limitStr + "] - limit will be [" + limit + "].");
        }
        return limit;
    }

    private void disableBrowserCache(HttpServletResponse resp) {
        resp.setHeader("Cache-Control", "no-cache, no-store");
        resp.setHeader("Expires", "-1");
        resp.setHeader("Pragma", "no-cache");
    }

    private void sendErrorDownloadsDisabled(HttpServletResponse resp) throws IOException {
        this.disableBrowserCache(resp);
        resp.sendError(403, "Downloads have been disabled");
    }

    private void sendErrorTooManyDownloads(HttpServletResponse resp) throws IOException {
        this.disableBrowserCache(resp);
        resp.setHeader("Retry-After", "30");
        resp.sendError(503, "Maximum limit exceeded - try again later");
    }

    private String getClientAddress(HttpServletRequest request) {
        String ip = request.getHeader("X-Forwarded-For");
        if ((ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) && ((ip = request.getHeader("HTTP_X_FORWARDED_FOR")) == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip))) {
            ip = String.format("%s (%s)", request.getRemoteHost(), request.getRemoteAddr());
        }
        return ip;
    }

    private void copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[32768];
        input = new BufferedInputStream(input, buffer.length);
        int bytesRead = input.read(buffer);
        while (bytesRead != -1) {
            output.write(buffer, 0, bytesRead);
            bytesRead = input.read(buffer);
        }
        output.flush();
    }

    private File getAgentModuleDownloadFile() throws Exception {
        if (this.moduleDownloadFile != null) {
            if (this.moduleDownloadFile.exists()) {
                return this.moduleDownloadFile;
            }
            this.moduleDownloadFile = null;
        }
        File configDir = new File(System.getProperty("jboss.server.config.dir"));
        for (File file : configDir.listFiles()) {
            if (!file.getName().startsWith("hawkular-wildfly-agent-wf-extension") || !file.getName().endsWith(".zip")) continue;
            this.moduleDownloadFile = file;
            return this.moduleDownloadFile;
        }
        throw new FileNotFoundException("Cannot find agent module download in: " + configDir);
    }

    private File getAgentInstallerDownloadFile() throws Exception {
        if (this.installerDownloadFile != null) {
            if (this.installerDownloadFile.exists()) {
                return this.installerDownloadFile;
            }
            this.installerDownloadFile = null;
        }
        File configDir = new File(System.getProperty("jboss.server.config.dir"));
        for (File file : configDir.listFiles()) {
            if (!file.getName().startsWith("hawkular-wildfly-agent-installer") || !file.getName().endsWith(".jar")) continue;
            this.installerDownloadFile = file;
            return this.installerDownloadFile;
        }
        throw new FileNotFoundException("Cannot find agent installer download in: " + configDir);
    }
}

