/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.clients.ptrans.collectd.event;

import java.util.Collections;
import java.util.List;
import org.hawkular.metrics.clients.ptrans.collectd.event.Event;
import org.hawkular.metrics.clients.ptrans.collectd.event.TimeResolution;
import org.hawkular.metrics.clients.ptrans.collectd.event.TimeSpan;
import org.hawkular.metrics.clients.ptrans.util.Arguments;

public final class ValueListEvent
extends Event {
    private final List<Number> values;
    private final TimeSpan interval;

    public ValueListEvent(String host, TimeSpan timestamp, String pluginName, String pluginInstance, String typeName, String typeInstance, List<Number> values, TimeSpan interval) {
        super(host, timestamp, pluginName, pluginInstance, typeName, typeInstance);
        Arguments.checkArgument(values != null, "values is null", new Object[0]);
        Arguments.checkArgument(interval != null, "interval is null", new Object[0]);
        this.values = Collections.unmodifiableList(values);
        this.interval = interval;
    }

    public List<Number> getValues() {
        return this.values;
    }

    public TimeSpan getInterval() {
        return this.interval;
    }

    @Override
    public String toString() {
        return "ValueListEvent[" + super.toString() + ", values=" + this.values + ", interval=" + TimeResolution.toMillis(this.interval) + " ms" + ']';
    }
}

