/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.clients.ptrans;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.net.URI;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.hawkular.metrics.clients.ptrans.ConfigurationKey;
import org.hawkular.metrics.clients.ptrans.Service;

public class Configuration {
    private final Set<Service> services;
    private final int udpPort;
    private final int tcpPort;
    private final int gangliaPort;
    private final String gangliaGroup;
    private final String multicastIfOverride;
    private final int statsDport;
    private final int collectdPort;
    private final int graphitePort;
    private final URI metricsUrl;
    private final boolean sendTenant;
    private final String tenant;
    private final boolean authEnabled;
    private final String authId;
    private final String authSecret;
    private final JsonObject httpHeaders;
    private final int maxConnections;
    private final int batchSize;
    private final Set<String> validationMessages;

    private Configuration(Set<Service> services, int udpPort, int tcpPort, int gangliaPort, String gangliaGroup, String multicastIfOverride, int statsDport, int collectdPort, int graphitePort, URI metricsUrl, boolean sendTenant, String tenant, boolean authEnabled, String authId, String authSecret, JsonObject httpHeaders, int maxConnections, int batchSize, Set<String> validationMessages) {
        this.services = services;
        this.udpPort = udpPort;
        this.tcpPort = tcpPort;
        this.gangliaPort = gangliaPort;
        this.gangliaGroup = gangliaGroup;
        this.multicastIfOverride = multicastIfOverride;
        this.statsDport = statsDport;
        this.collectdPort = collectdPort;
        this.graphitePort = graphitePort;
        this.metricsUrl = metricsUrl;
        this.sendTenant = sendTenant;
        this.tenant = tenant;
        this.authEnabled = authEnabled;
        this.authId = authId;
        this.authSecret = authSecret;
        this.httpHeaders = httpHeaders;
        this.maxConnections = maxConnections;
        this.batchSize = batchSize;
        this.validationMessages = Collections.unmodifiableSet(validationMessages);
    }

    public static Configuration from(Properties properties) {
        HashSet<String> validationMessages = new HashSet<String>();
        Set<Service> services = Configuration.getServices(properties, validationMessages);
        int udpPort = Configuration.getIntProperty(properties, ConfigurationKey.SERVICES_UDP_PORT, 5140);
        int tcpPort = Configuration.getIntProperty(properties, ConfigurationKey.SERVICES_TCP_PORT, 5140);
        int gangliaPort = Configuration.getIntProperty(properties, ConfigurationKey.SERVICES_GANGLIA_PORT, 8649);
        String gangliaGroup = properties.getProperty(ConfigurationKey.SERVICES_GANGLIA_GROUP.toString(), "239.2.11.71");
        String multicastIfOverride = properties.getProperty(ConfigurationKey.SERVICES_GANGLIA_MULTICAST_INTERFACE.toString());
        int statsDport = Configuration.getIntProperty(properties, ConfigurationKey.SERVICES_STATSD_PORT, 8125);
        int collectdPort = Configuration.getIntProperty(properties, ConfigurationKey.SERVICES_COLLECTD_PORT, 25826);
        int graphitePort = Configuration.getIntProperty(properties, ConfigurationKey.SERVICES_GRAPHITE_PORT, 2003);
        URI metricsUrl = URI.create(properties.getProperty(ConfigurationKey.METRICS_URL.toString(), "http://localhost:8080/hawkular/metrics/gauges/raw"));
        boolean sendTenant = Configuration.getBooleanProperty(properties, ConfigurationKey.METRICS_TENANT_SEND.toString(), true);
        String tenant = properties.getProperty(ConfigurationKey.METRICS_TENANT.toString(), "default");
        boolean authEnabled = Configuration.getBooleanProperty(properties, ConfigurationKey.METRICS_AUTH_ENABLED.toString(), false);
        String authId = properties.getProperty(ConfigurationKey.METRICS_AUTH_ID.toString());
        String authSecret = properties.getProperty(ConfigurationKey.METRICS_AUTH_SECRET.toString());
        JsonObject httpHeaders = Configuration.getHttpHeaders(properties);
        int maxConnections = Configuration.getIntProperty(properties, ConfigurationKey.METRICS_MAX_CONNECTIONS, 10);
        int batchSize = Configuration.getIntProperty(properties, ConfigurationKey.METRICS_BATCH_SIZE, 50);
        return new Configuration(services, udpPort, tcpPort, gangliaPort, gangliaGroup, multicastIfOverride, statsDport, collectdPort, graphitePort, metricsUrl, sendTenant, tenant, authEnabled, authId, authSecret, httpHeaders, maxConnections, batchSize, validationMessages);
    }

    private static Set<Service> getServices(Properties properties, Set<String> validationMessages) {
        String servicesProperty = properties.getProperty(ConfigurationKey.SERVICES.toString());
        if (servicesProperty == null) {
            validationMessages.add(String.format(Locale.ROOT, "Property %s not found", ConfigurationKey.SERVICES.toString()));
            return Collections.emptySet();
        }
        EnumSet<Service> services = EnumSet.noneOf(Service.class);
        StringTokenizer tokenizer = new StringTokenizer(servicesProperty, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            if (token.isEmpty()) continue;
            Service service = Service.findByExternalForm(token);
            if (service == null) {
                validationMessages.add(String.format(Locale.ROOT, "Unknown service %s", token));
                continue;
            }
            services.add(service);
        }
        if (services.isEmpty()) {
            validationMessages.add("Empty services list");
        }
        return services;
    }

    private static int getIntProperty(Properties properties, ConfigurationKey key, int defaultValue) {
        String property = properties.getProperty(key.toString());
        if (property == null) {
            return defaultValue;
        }
        return Integer.parseInt(property);
    }

    private static boolean getBooleanProperty(Properties properties, String name, boolean defaultValue) {
        String property = properties.getProperty(name);
        if (property == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(property);
    }

    private static JsonObject getHttpHeaders(Properties properties) {
        JsonObject jsonObject = new JsonObject();
        Set<Object> keys = properties.keySet();
        String namePrefix = "metrics.http.header.";
        String nameSuffix = ".name";
        Set<String> headerIds = keys.stream().filter(k -> k instanceof String).map(String.class::cast).filter(name -> name.startsWith(namePrefix) && name.endsWith(nameSuffix)).map(name -> name.substring(namePrefix.length(), name.length() - nameSuffix.length())).collect(Collectors.toSet());
        headerIds.forEach(headerId -> {
            String headerName = properties.getProperty(namePrefix + headerId + nameSuffix);
            String valuePrefix = namePrefix + headerId + ".value.";
            List<Integer> headerPriorities = keys.stream().filter(k -> k instanceof String).map(String.class::cast).filter(name -> name.startsWith(valuePrefix)).map(name -> name.substring(valuePrefix.length())).filter(orderStr -> orderStr.matches("\\d{1,2}")).map(Integer::valueOf).sorted().collect(Collectors.toList());
            if (!headerPriorities.isEmpty()) {
                if (headerPriorities.size() == 1) {
                    String headerValue = properties.getProperty(valuePrefix + headerPriorities.iterator().next());
                    jsonObject.put(headerName, headerValue);
                } else {
                    JsonArray headerValues = new JsonArray();
                    headerPriorities.forEach(headerPriority -> {
                        String headerValue = properties.getProperty(valuePrefix + headerPriority);
                        headerValues.add(headerValue);
                    });
                    jsonObject.put(headerName, headerValues);
                }
            }
        });
        return jsonObject;
    }

    public boolean isValid() {
        return this.validationMessages.isEmpty();
    }

    public Set<String> getValidationMessages() {
        return this.validationMessages;
    }

    public Set<Service> getServices() {
        return this.services;
    }

    public int getUdpPort() {
        return this.udpPort;
    }

    public int getTcpPort() {
        return this.tcpPort;
    }

    public int getGangliaPort() {
        return this.gangliaPort;
    }

    public int getStatsDport() {
        return this.statsDport;
    }

    public int getCollectdPort() {
        return this.collectdPort;
    }

    public int getGraphitePort() {
        return this.graphitePort;
    }

    public String getGangliaGroup() {
        return this.gangliaGroup;
    }

    public String getMulticastIfOverride() {
        return this.multicastIfOverride;
    }

    public URI getMetricsUrl() {
        return this.metricsUrl;
    }

    public boolean isSendTenant() {
        return this.sendTenant;
    }

    public String getTenant() {
        return this.tenant;
    }

    public boolean isAuthEnabled() {
        return this.authEnabled;
    }

    public String getAuthId() {
        return this.authId;
    }

    public String getAuthSecret() {
        return this.authSecret;
    }

    public JsonObject getHttpHeaders() {
        return this.httpHeaders;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public int getBatchSize() {
        return this.batchSize;
    }
}

