/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.clients.ptrans;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.util.CharsetUtil;
import java.util.List;
import org.hawkular.metrics.clients.ptrans.syslog.SyslogEventDecoder;
import org.jboss.logging.Logger;

public class DemuxHandler
extends ByteToMessageDecoder {
    private static final Logger log = Logger.getLogger(DemuxHandler.class);
    private ChannelInboundHandlerAdapter forwardingHandler;

    public DemuxHandler(ChannelInboundHandlerAdapter forwardingHandler) {
        this.forwardingHandler = forwardingHandler;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf msg, List out) throws Exception {
        if (msg.readableBytes() < 5) {
            msg.clear();
            ctx.close();
            return;
        }
        ChannelPipeline pipeline = ctx.pipeline();
        String data = msg.toString(CharsetUtil.UTF_8);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Incoming: [" + data + "]"));
        }
        boolean done = false;
        if (data.contains("type=metric")) {
            pipeline.addLast(new ChannelHandler[]{new SyslogEventDecoder()});
            pipeline.addLast("forwarder", (ChannelHandler)this.forwardingHandler);
            pipeline.remove((ChannelHandler)this);
            done = true;
        }
        if (!done) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Unknown input [" + data + "], ignoring"));
            }
            msg.clear();
            ctx.close();
        }
    }
}

