/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.clients.ptrans.collectd.event;

import java.util.HashMap;
import java.util.Map;

public enum DataType {
    GAUGE(1),
    DERIVE(2),
    COUNTER(0),
    ABSOLUTE(3);

    private byte id;
    private static final Map<Byte, DataType> TYPE_BY_ID;

    private DataType(byte id) {
        this.id = id;
    }

    public byte getId() {
        return this.id;
    }

    public static DataType findById(byte id) {
        return TYPE_BY_ID.get(id);
    }

    static {
        TYPE_BY_ID = new HashMap<Byte, DataType>();
        for (DataType dataType : DataType.values()) {
            TYPE_BY_ID.put(dataType.id, dataType);
        }
    }

    private static class DataTypeId {
        private static final byte COUNTER = 0;
        private static final byte GAUGE = 1;
        private static final byte DERIVE = 2;
        private static final byte ABSOLUTE = 3;

        private DataTypeId() {
        }
    }
}

