/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.clients.ptrans.collectd.packet;

import java.util.Collections;
import java.util.List;
import org.hawkular.metrics.clients.ptrans.collectd.event.DataType;
import org.hawkular.metrics.clients.ptrans.util.Arguments;

public final class Values {
    private final List<DataType> dataTypes;
    private final List<Number> data;

    public Values(List<DataType> dataTypes, List<Number> data) {
        Arguments.checkArgument(dataTypes != null, "dataTypes is null", new Object[0]);
        Arguments.checkArgument(data != null, "data is null", new Object[0]);
        Arguments.checkArgument(dataTypes.size() == data.size(), "dataTypes and data arrays have different sizes: %d, %d", dataTypes.size(), data.size());
        this.dataTypes = Collections.unmodifiableList(dataTypes);
        this.data = Collections.unmodifiableList(data);
    }

    public int getCount() {
        return this.data.size();
    }

    public List<DataType> getDataTypes() {
        return this.dataTypes;
    }

    public List<Number> getData() {
        return this.data;
    }

    public String toString() {
        return "Values[dataTypes=" + this.dataTypes + ", data=" + this.data + ']';
    }
}

