/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.hawkular.impl;

import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.SocketAddressImpl;
import io.vertx.core.spi.metrics.DatagramSocketMetrics;
import io.vertx.ext.hawkular.impl.DatagramSocketMetricsSupplier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;

public class DatagramSocketMetricsImpl
implements DatagramSocketMetrics {
    private final ConcurrentMap<SocketAddress, LongAdder> bytesReceived = new ConcurrentHashMap<SocketAddress, LongAdder>(0);
    private final ConcurrentMap<SocketAddress, LongAdder> bytesSent = new ConcurrentHashMap<SocketAddress, LongAdder>(0);
    private final LongAdder errors = new LongAdder();
    private final DatagramSocketMetricsSupplier datagramSocketMetricsSupplier;
    private volatile SocketAddress localAddress;

    public DatagramSocketMetricsImpl(DatagramSocketMetricsSupplier datagramSocketMetricsSupplier) {
        this.datagramSocketMetricsSupplier = datagramSocketMetricsSupplier;
        datagramSocketMetricsSupplier.register(this);
    }

    @Override
    public void listening(String localName, SocketAddress localAddress) {
        this.localAddress = new SocketAddressImpl(localAddress.port(), localName);
    }

    @Override
    public void bytesRead(Void socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        LongAdder counter = (LongAdder)this.bytesReceived.get(this.localAddress);
        if (counter == null) {
            counter = this.bytesReceived.computeIfAbsent(this.localAddress, address -> new LongAdder());
        }
        counter.add(numberOfBytes);
    }

    @Override
    public void bytesWritten(Void socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        LongAdder counter = (LongAdder)this.bytesSent.get(remoteAddress);
        if (counter == null) {
            counter = this.bytesSent.computeIfAbsent(remoteAddress, address -> new LongAdder());
        }
        counter.add(numberOfBytes);
    }

    @Override
    public void exceptionOccurred(Void socketMetric, SocketAddress remoteAddress, Throwable t) {
        this.errors.increment();
    }

    public Map<SocketAddress, Long> getBytesReceived() {
        return this.bytesReceived.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((LongAdder)e.getValue()).sum()));
    }

    public Map<SocketAddress, Long> getBytesSent() {
        return this.bytesSent.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((LongAdder)e.getValue()).sum()));
    }

    public long getErrorCount() {
        return this.errors.sum();
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void close() {
        this.datagramSocketMetricsSupplier.unregister(this);
    }
}

