/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.hawkular.impl;

import io.vertx.core.net.SocketAddress;
import io.vertx.ext.hawkular.impl.CounterPoint;
import io.vertx.ext.hawkular.impl.DataPoint;
import io.vertx.ext.hawkular.impl.DatagramSocketMetricsImpl;
import io.vertx.ext.hawkular.impl.MetricSupplier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class DatagramSocketMetricsSupplier
implements MetricSupplier {
    private final String baseName;
    private final Set<DatagramSocketMetricsImpl> metricsSet = new CopyOnWriteArraySet<DatagramSocketMetricsImpl>();

    public DatagramSocketMetricsSupplier(String prefix) {
        this.baseName = prefix + (prefix.isEmpty() ? "" : ".") + "vertx.datagram.";
    }

    @Override
    public List<DataPoint> collect() {
        long timestamp = System.currentTimeMillis();
        HashMap<SocketAddress, Long> received = new HashMap<SocketAddress, Long>();
        HashMap<SocketAddress, Long> sent = new HashMap<SocketAddress, Long>();
        long errorCount = 0L;
        for (DatagramSocketMetricsImpl datagramSocketMetrics : this.metricsSet) {
            datagramSocketMetrics.getBytesReceived().forEach((address, bytes) -> received.merge((SocketAddress)address, (Long)bytes, Long::sum));
            datagramSocketMetrics.getBytesSent().forEach((address, bytes) -> sent.merge((SocketAddress)address, (Long)bytes, Long::sum));
            errorCount += datagramSocketMetrics.getErrorCount();
        }
        ArrayList<DataPoint> res = new ArrayList<DataPoint>(received.size() + sent.size() + 1);
        received.forEach((address, count) -> {
            String addressId = address.host() + ":" + address.port();
            res.add(new CounterPoint(this.baseName + addressId + ".bytesReceived", timestamp, (long)count));
        });
        sent.forEach((address, count) -> {
            String addressId = address.host() + ":" + address.port();
            res.add(new CounterPoint(this.baseName + addressId + ".bytesSent", timestamp, (long)count));
        });
        res.add(new CounterPoint(this.baseName + "errorCount", timestamp, errorCount));
        return res;
    }

    public void register(DatagramSocketMetricsImpl datagramSocketMetrics) {
        this.metricsSet.add(datagramSocketMetrics);
    }

    public void unregister(DatagramSocketMetricsImpl datagramSocketMetrics) {
        this.metricsSet.remove(datagramSocketMetrics);
    }
}

