/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.hawkular.impl;

import io.vertx.core.eventbus.ReplyFailure;
import io.vertx.core.spi.metrics.EventBusMetrics;
import io.vertx.ext.hawkular.impl.CounterPoint;
import io.vertx.ext.hawkular.impl.DataPoint;
import io.vertx.ext.hawkular.impl.EventBusHandlerMetrics;
import io.vertx.ext.hawkular.impl.GaugePoint;
import io.vertx.ext.hawkular.impl.HandlersMeasurements;
import io.vertx.ext.hawkular.impl.MetricSupplier;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.LongAdder;

public class EventBusMetricsImpl
implements EventBusMetrics<EventBusHandlerMetrics>,
MetricSupplier {
    private final String baseName;
    private final LongAdder handlers = new LongAdder();
    private final ConcurrentMap<String, HandlersMeasurements> handlersMeasurements = new ConcurrentHashMap<String, HandlersMeasurements>(0);
    private final LongAdder errorCount = new LongAdder();
    private final LongAdder bytesWritten = new LongAdder();
    private final LongAdder bytesRead = new LongAdder();
    private final LongAdder pending = new LongAdder();
    private final LongAdder pendingLocal = new LongAdder();
    private final LongAdder pendingRemote = new LongAdder();
    private final LongAdder publishedMessages = new LongAdder();
    private final LongAdder publishedLocalMessages = new LongAdder();
    private final LongAdder publishedRemoteMessages = new LongAdder();
    private final LongAdder sentMessages = new LongAdder();
    private final LongAdder sentLocalMessages = new LongAdder();
    private final LongAdder sentRemoteMessages = new LongAdder();
    private final LongAdder receivedMessages = new LongAdder();
    private final LongAdder receivedLocalMessages = new LongAdder();
    private final LongAdder receivedRemoteMessages = new LongAdder();
    private final LongAdder deliveredMessages = new LongAdder();
    private final LongAdder deliveredLocalMessages = new LongAdder();
    private final LongAdder deliveredRemoteMessages = new LongAdder();
    private final LongAdder replyFailures = new LongAdder();

    public EventBusMetricsImpl(String prefix) {
        this.baseName = prefix + (prefix.isEmpty() ? "" : ".") + "vertx.eventbus.";
    }

    @Override
    public EventBusHandlerMetrics handlerRegistered(String address, String repliedAddress) {
        HandlersMeasurements candidate;
        HandlersMeasurements current;
        this.handlers.increment();
        EventBusHandlerMetrics handlerMetrics = new EventBusHandlerMetrics(address);
        while (!((current = (HandlersMeasurements)this.handlersMeasurements.get(address)) != null ? this.handlersMeasurements.replace(address, current, candidate = current.incrementHandlersCount()) : this.handlersMeasurements.putIfAbsent(address, candidate = new HandlersMeasurements()) == null)) {
        }
        return handlerMetrics;
    }

    @Override
    public void handlerUnregistered(EventBusHandlerMetrics handlerMetrics) {
        HandlersMeasurements current;
        HandlersMeasurements candidate;
        this.handlers.decrement();
        String address = handlerMetrics.getAddress();
        while (!((candidate = (current = (HandlersMeasurements)this.handlersMeasurements.get(address)).decrementHandlersCount()).handlersCount() == 0 ? this.handlersMeasurements.remove(address, current) : this.handlersMeasurements.replace(address, current, candidate))) {
        }
    }

    @Override
    public void scheduleMessage(EventBusHandlerMetrics eventBusHandlerMetrics, boolean b) {
    }

    @Override
    public void beginHandleMessage(EventBusHandlerMetrics handlerMetrics, boolean local) {
        this.pending.decrement();
        if (local) {
            this.pendingLocal.decrement();
        } else {
            this.pendingRemote.decrement();
        }
        handlerMetrics.resetTimer();
    }

    @Override
    public void endHandleMessage(EventBusHandlerMetrics handlerMetrics, Throwable failure) {
        long elapsed = handlerMetrics.elapsed();
        HandlersMeasurements handlersMeasurements = (HandlersMeasurements)this.handlersMeasurements.get(handlerMetrics.getAddress());
        if (handlersMeasurements != null) {
            handlersMeasurements.addProcessingTime(elapsed);
        }
        if (failure != null) {
            this.errorCount.increment();
        }
    }

    @Override
    public void messageSent(String address, boolean publish, boolean local, boolean remote) {
        if (publish) {
            this.publishedMessages.increment();
            if (local) {
                this.publishedLocalMessages.increment();
            } else {
                this.publishedRemoteMessages.increment();
            }
        } else {
            this.sentMessages.increment();
            if (local) {
                this.sentLocalMessages.increment();
            } else {
                this.sentRemoteMessages.increment();
            }
        }
    }

    @Override
    public void messageReceived(String address, boolean publish, boolean local, int handlers) {
        this.pending.add(handlers);
        this.receivedMessages.increment();
        if (local) {
            this.receivedLocalMessages.increment();
            this.pendingLocal.add(handlers);
        } else {
            this.receivedRemoteMessages.increment();
            this.pendingRemote.add(handlers);
        }
        if (handlers > 0) {
            this.deliveredMessages.increment();
            if (local) {
                this.deliveredLocalMessages.increment();
            } else {
                this.deliveredRemoteMessages.increment();
            }
        }
    }

    @Override
    public void messageWritten(String address, int numberOfBytes) {
        this.bytesWritten.add(numberOfBytes);
    }

    @Override
    public void messageRead(String address, int numberOfBytes) {
        this.bytesRead.add(numberOfBytes);
    }

    @Override
    public void replyFailure(String address, ReplyFailure failure) {
        this.replyFailures.increment();
    }

    @Override
    public List<DataPoint> collect() {
        long timestamp = System.currentTimeMillis();
        ArrayList<DataPoint> dataPoints = new ArrayList<DataPoint>();
        dataPoints.add(new GaugePoint(this.baseName + "handlers", timestamp, this.handlers.sum()));
        this.handlersMeasurements.entrySet().forEach(e -> {
            String address = (String)e.getKey();
            HandlersMeasurements measurements = (HandlersMeasurements)e.getValue();
            String source = address + ".processingTime";
            dataPoints.add(new CounterPoint(this.baseName + source, timestamp, measurements.processingTime()));
        });
        dataPoints.add(new CounterPoint(this.baseName + "errorCount", timestamp, this.errorCount.sum()));
        dataPoints.add(new CounterPoint(this.baseName + "bytesWritten", timestamp, this.bytesWritten.sum()));
        dataPoints.add(new CounterPoint(this.baseName + "bytesRead", timestamp, this.bytesRead.sum()));
        dataPoints.add(new GaugePoint(this.baseName + "pending", timestamp, this.pending.sum()));
        dataPoints.add(new GaugePoint(this.baseName + "pendingLocal", timestamp, this.pendingLocal.sum()));
        dataPoints.add(new GaugePoint(this.baseName + "pendingRemote", timestamp, this.pendingRemote.sum()));
        dataPoints.add(new CounterPoint(this.baseName + "publishedMessages", timestamp, this.publishedMessages.sum()));
        dataPoints.add(new CounterPoint(this.baseName + "publishedLocalMessages", timestamp, this.publishedLocalMessages.sum()));
        dataPoints.add(new CounterPoint(this.baseName + "publishedRemoteMessages", timestamp, this.publishedRemoteMessages.sum()));
        dataPoints.add(new CounterPoint(this.baseName + "sentMessages", timestamp, this.sentMessages.sum()));
        dataPoints.add(new CounterPoint(this.baseName + "sentLocalMessages", timestamp, this.sentLocalMessages.sum()));
        dataPoints.add(new CounterPoint(this.baseName + "sentRemoteMessages", timestamp, this.sentRemoteMessages.sum()));
        dataPoints.add(new CounterPoint(this.baseName + "receivedMessages", timestamp, this.receivedMessages.sum()));
        dataPoints.add(new CounterPoint(this.baseName + "receivedLocalMessages", timestamp, this.receivedLocalMessages.sum()));
        dataPoints.add(new CounterPoint(this.baseName + "receivedRemoteMessages", timestamp, this.receivedRemoteMessages.sum()));
        dataPoints.add(new CounterPoint(this.baseName + "deliveredMessages", timestamp, this.deliveredMessages.sum()));
        dataPoints.add(new CounterPoint(this.baseName + "deliveredLocalMessages", timestamp, this.deliveredLocalMessages.sum()));
        dataPoints.add(new CounterPoint(this.baseName + "deliveredRemoteMessages", timestamp, this.deliveredRemoteMessages.sum()));
        dataPoints.add(new CounterPoint(this.baseName + "replyFailures", timestamp, this.replyFailures.sum()));
        return dataPoints;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void close() {
    }
}

