/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.hawkular.impl;

import io.vertx.ext.hawkular.impl.NetClientConnectionsMeasurements;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;

public class HttpClientConnectionsMeasurements {
    private final NetClientConnectionsMeasurements tcpMeasurements = new NetClientConnectionsMeasurements();
    private final LongAdder requests = new LongAdder();
    private final LongAdder requestCount = new LongAdder();
    private final LongAdder responseTime = new LongAdder();
    private final LongAdder wsConnections = new LongAdder();

    public void incrementConnections() {
        this.tcpMeasurements.incrementConnections();
    }

    public void decrementConnections() {
        this.tcpMeasurements.decrementConnections();
    }

    public void addBytesReceived(long numberOfBytes) {
        this.tcpMeasurements.addBytesReceived(numberOfBytes);
    }

    public void addBytesSent(long numberOfBytes) {
        this.tcpMeasurements.addBytesSent(numberOfBytes);
    }

    public void incrementErrorCount() {
        this.tcpMeasurements.incrementErrorCount();
    }

    public void requestBegin() {
        this.requests.increment();
        this.requestCount.increment();
    }

    public void requestReset() {
        this.requests.decrement();
    }

    public void responseEnd(long responseTime) {
        this.requests.decrement();
        this.responseTime.add(responseTime);
    }

    public void incrementWsConnectionCount() {
        this.wsConnections.increment();
    }

    public void decrementWsConnectionCount() {
        this.wsConnections.increment();
    }

    public Snapshot getSnapshot() {
        return new Snapshot(this.tcpMeasurements.getSnapshot(), this.requests.sum(), this.requestCount.sum(), this.responseTime.sum(), this.wsConnections.sum());
    }

    public static class Snapshot {
        private final NetClientConnectionsMeasurements.Snapshot tcpMeasurementsSnapshot;
        private final long requests;
        private final long requestCount;
        private final long responseTime;
        private final long wsConnections;

        private Snapshot(NetClientConnectionsMeasurements.Snapshot tcpMeasurementsSnapshot, long requests, long requestCount, long responseTime, long wsConnections) {
            this.tcpMeasurementsSnapshot = tcpMeasurementsSnapshot;
            this.requests = requests;
            this.requestCount = requestCount;
            this.responseTime = responseTime;
            this.wsConnections = wsConnections;
        }

        public long getConnections() {
            return this.tcpMeasurementsSnapshot.getConnections();
        }

        public long getBytesReceived() {
            return this.tcpMeasurementsSnapshot.getBytesReceived();
        }

        public long getBytesSent() {
            return this.tcpMeasurementsSnapshot.getBytesSent();
        }

        public long getErrorCount() {
            return this.tcpMeasurementsSnapshot.getErrorCount();
        }

        public long getRequests() {
            return this.requests;
        }

        public long getRequestCount() {
            return this.requestCount;
        }

        public long getResponseTime() {
            return TimeUnit.MILLISECONDS.convert(this.responseTime, TimeUnit.NANOSECONDS);
        }

        public long getWsConnections() {
            return this.wsConnections;
        }

        public static Snapshot merge(Snapshot s1, Snapshot s2) {
            NetClientConnectionsMeasurements.Snapshot tcpMeasurementsSnapshot = NetClientConnectionsMeasurements.Snapshot.merge(s1.tcpMeasurementsSnapshot, s2.tcpMeasurementsSnapshot);
            return new Snapshot(tcpMeasurementsSnapshot, s1.requests + s2.requests, s1.requestCount + s2.requestCount, s1.responseTime + s2.responseTime, s1.wsConnections + s1.wsConnections);
        }
    }
}

