/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.hawkular.impl;

import io.vertx.core.net.SocketAddress;
import io.vertx.ext.hawkular.impl.CounterPoint;
import io.vertx.ext.hawkular.impl.DataPoint;
import io.vertx.ext.hawkular.impl.GaugePoint;
import io.vertx.ext.hawkular.impl.HttpClientConnectionsMeasurements;
import io.vertx.ext.hawkular.impl.HttpClientMetricsImpl;
import io.vertx.ext.hawkular.impl.MetricSupplier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class HttpClientMetricsSupplier
implements MetricSupplier {
    private final String baseName;
    private final Set<HttpClientMetricsImpl> metricsSet = new CopyOnWriteArraySet<HttpClientMetricsImpl>();

    public HttpClientMetricsSupplier(String prefix) {
        this.baseName = prefix + (prefix.isEmpty() ? "" : ".") + "vertx.http.client.";
    }

    @Override
    public List<DataPoint> collect() {
        long timestamp = System.currentTimeMillis();
        HashMap<SocketAddress, HttpClientConnectionsMeasurements.Snapshot> values = new HashMap<SocketAddress, HttpClientConnectionsMeasurements.Snapshot>();
        for (HttpClientMetricsImpl httpClientMetrics : this.metricsSet) {
            httpClientMetrics.getMeasurementsSnapshot().forEach((address, snapshot) -> values.merge((SocketAddress)address, (HttpClientConnectionsMeasurements.Snapshot)snapshot, HttpClientConnectionsMeasurements.Snapshot::merge));
        }
        ArrayList<DataPoint> res = new ArrayList<DataPoint>();
        values.forEach((address, snapshot) -> {
            String addressId = address.host() + ":" + address.port();
            res.add(new GaugePoint(this.baseName + addressId + ".connections", timestamp, snapshot.getConnections()));
            res.add(new CounterPoint(this.baseName + addressId + ".bytesReceived", timestamp, snapshot.getBytesReceived()));
            res.add(new CounterPoint(this.baseName + addressId + ".bytesSent", timestamp, snapshot.getBytesSent()));
            res.add(new CounterPoint(this.baseName + addressId + ".errorCount", timestamp, snapshot.getErrorCount()));
            res.add(new GaugePoint(this.baseName + addressId + ".requests", timestamp, snapshot.getRequests()));
            res.add(new CounterPoint(this.baseName + addressId + ".requestCount", timestamp, snapshot.getRequestCount()));
            res.add(new CounterPoint(this.baseName + addressId + ".responseTime", timestamp, snapshot.getResponseTime()));
            res.add(new GaugePoint(this.baseName + addressId + ".wsConnections", timestamp, snapshot.getWsConnections()));
        });
        return res;
    }

    public void register(HttpClientMetricsImpl httpClientMetrics) {
        this.metricsSet.add(httpClientMetrics);
    }

    public void unregister(HttpClientMetricsImpl httpClientMetrics) {
        this.metricsSet.remove(httpClientMetrics);
    }
}

