/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.hawkular.impl;

import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.SocketAddressImpl;
import io.vertx.core.spi.metrics.TCPMetrics;
import io.vertx.ext.hawkular.impl.NetClientConnectionsMeasurements;
import io.vertx.ext.hawkular.impl.NetClientMetricsSupplier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

public class NetClientMetricsImpl
implements TCPMetrics<SocketAddress> {
    private final ConcurrentMap<SocketAddress, NetClientConnectionsMeasurements> connectionsMeasurements = new ConcurrentHashMap<SocketAddress, NetClientConnectionsMeasurements>(0);
    private final NetClientMetricsSupplier netClientMetricsSupplier;

    public NetClientMetricsImpl(NetClientMetricsSupplier netClientMetricsSupplier) {
        this.netClientMetricsSupplier = netClientMetricsSupplier;
        netClientMetricsSupplier.register(this);
    }

    @Override
    public SocketAddress connected(SocketAddress remoteAddress, String remoteName) {
        SocketAddressImpl key = new SocketAddressImpl(remoteAddress.port(), remoteName);
        NetClientConnectionsMeasurements measurements = (NetClientConnectionsMeasurements)this.connectionsMeasurements.get(key);
        if (measurements == null) {
            measurements = this.connectionsMeasurements.computeIfAbsent(key, address -> new NetClientConnectionsMeasurements());
        }
        measurements.incrementConnections();
        return key;
    }

    @Override
    public void disconnected(SocketAddress key, SocketAddress remoteAddress) {
        NetClientConnectionsMeasurements measurements = (NetClientConnectionsMeasurements)this.connectionsMeasurements.get(key);
        if (measurements != null) {
            measurements.decrementConnections();
        }
    }

    @Override
    public void bytesRead(SocketAddress key, SocketAddress remoteAddress, long numberOfBytes) {
        NetClientConnectionsMeasurements measurements = (NetClientConnectionsMeasurements)this.connectionsMeasurements.get(key);
        if (measurements != null) {
            measurements.addBytesReceived(numberOfBytes);
        }
    }

    @Override
    public void bytesWritten(SocketAddress key, SocketAddress remoteAddress, long numberOfBytes) {
        NetClientConnectionsMeasurements measurements = (NetClientConnectionsMeasurements)this.connectionsMeasurements.get(key);
        if (measurements != null) {
            measurements.addBytesSent(numberOfBytes);
        }
    }

    @Override
    public void exceptionOccurred(SocketAddress key, SocketAddress remoteAddress, Throwable t) {
        NetClientConnectionsMeasurements measurements = (NetClientConnectionsMeasurements)this.connectionsMeasurements.get(key);
        if (measurements != null) {
            measurements.incrementErrorCount();
        }
    }

    public Map<SocketAddress, NetClientConnectionsMeasurements.Snapshot> getMeasurementsSnapshot() {
        return this.connectionsMeasurements.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((NetClientConnectionsMeasurements)e.getValue()).getSnapshot()));
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void close() {
        this.netClientMetricsSupplier.unregister(this);
    }
}

