/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.hawkular.impl;

import io.vertx.core.net.SocketAddress;
import io.vertx.ext.hawkular.impl.CounterPoint;
import io.vertx.ext.hawkular.impl.DataPoint;
import io.vertx.ext.hawkular.impl.GaugePoint;
import io.vertx.ext.hawkular.impl.MetricSupplier;
import io.vertx.ext.hawkular.impl.NetClientConnectionsMeasurements;
import io.vertx.ext.hawkular.impl.NetClientMetricsImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class NetClientMetricsSupplier
implements MetricSupplier {
    private final String baseName;
    private final Set<NetClientMetricsImpl> metricsSet = new CopyOnWriteArraySet<NetClientMetricsImpl>();

    public NetClientMetricsSupplier(String prefix) {
        this.baseName = prefix + (prefix.isEmpty() ? "" : ".") + "vertx.net.client.";
    }

    @Override
    public List<DataPoint> collect() {
        long timestamp = System.currentTimeMillis();
        HashMap<SocketAddress, NetClientConnectionsMeasurements.Snapshot> values = new HashMap<SocketAddress, NetClientConnectionsMeasurements.Snapshot>();
        for (NetClientMetricsImpl netClientMetrics : this.metricsSet) {
            netClientMetrics.getMeasurementsSnapshot().forEach((address, snapshot) -> values.merge((SocketAddress)address, (NetClientConnectionsMeasurements.Snapshot)snapshot, NetClientConnectionsMeasurements.Snapshot::merge));
        }
        ArrayList<DataPoint> res = new ArrayList<DataPoint>();
        values.forEach((address, snapshot) -> {
            String addressId = address.host() + ":" + address.port();
            res.add(new GaugePoint(this.baseName + addressId + ".connections", timestamp, snapshot.getConnections()));
            res.add(new CounterPoint(this.baseName + addressId + ".bytesReceived", timestamp, snapshot.getBytesReceived()));
            res.add(new CounterPoint(this.baseName + addressId + ".bytesSent", timestamp, snapshot.getBytesSent()));
            res.add(new CounterPoint(this.baseName + addressId + ".errorCount", timestamp, snapshot.getErrorCount()));
        });
        return res;
    }

    public void register(NetClientMetricsImpl netClientMetrics) {
        this.metricsSet.add(netClientMetrics);
    }

    public void unregister(NetClientMetricsImpl netClientMetrics) {
        this.metricsSet.remove(netClientMetrics);
    }
}

