/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.hawkular.impl;

import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.TCPMetrics;
import io.vertx.ext.hawkular.impl.NetServerMetricsSupplier;
import java.util.concurrent.atomic.LongAdder;

public class NetServerMetricsImpl
implements TCPMetrics<Void> {
    private final LongAdder connections = new LongAdder();
    private final LongAdder bytesReceived = new LongAdder();
    private final LongAdder bytesSent = new LongAdder();
    private final LongAdder errorCount = new LongAdder();
    private final SocketAddress localAddress;
    private final NetServerMetricsSupplier netServerMetricsSupplier;

    public NetServerMetricsImpl(SocketAddress localAddress, NetServerMetricsSupplier netServerMetricsSupplier) {
        this.localAddress = localAddress;
        this.netServerMetricsSupplier = netServerMetricsSupplier;
        netServerMetricsSupplier.register(this);
    }

    @Override
    public Void connected(SocketAddress remoteAddress, String remoteName) {
        this.connections.increment();
        return null;
    }

    @Override
    public void disconnected(Void socketMetric, SocketAddress remoteAddress) {
        this.connections.decrement();
    }

    @Override
    public void bytesRead(Void socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        this.bytesReceived.add(numberOfBytes);
    }

    @Override
    public void bytesWritten(Void socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        this.bytesSent.add(numberOfBytes);
    }

    @Override
    public void exceptionOccurred(Void socketMetric, SocketAddress remoteAddress, Throwable t) {
        this.errorCount.increment();
    }

    public SocketAddress getServerAddress() {
        return this.localAddress;
    }

    public long getConnections() {
        return this.connections.sum();
    }

    public long getBytesReceived() {
        return this.bytesReceived.sum();
    }

    public long getBytesSent() {
        return this.bytesSent.sum();
    }

    public long getErrorCount() {
        return this.errorCount.sum();
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void close() {
        this.netServerMetricsSupplier.unregister(this);
    }
}

